/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.extend;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.base.DynamicEnum;
import org.apache.servicecomb.foundation.common.base.EnumUtils;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.extend.ConcreteTypeRegister;
import org.apache.servicecomb.swagger.extend.DefaultModelResolveObjectMapperProvider;
import org.apache.servicecomb.swagger.extend.ModelResolveObjectMapperProvider;
import org.apache.servicecomb.swagger.extend.SwaggerEnum;
import org.apache.servicecomb.swagger.extend.property.creator.ByteArrayPropertyCreator;
import org.apache.servicecomb.swagger.extend.property.creator.BytePropertyCreator;
import org.apache.servicecomb.swagger.extend.property.creator.InputStreamPropertyCreator;
import org.apache.servicecomb.swagger.extend.property.creator.PartPropertyCreator;
import org.apache.servicecomb.swagger.extend.property.creator.PropertyCreator;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorFeature;

public class ModelResolverExt
extends ModelResolver {
    private final Map<Type, PropertyCreator> propertyCreatorMap = new HashMap<Type, PropertyCreator>();
    private final Set<Type> concreteInterfaces = new HashSet<Type>();

    public ModelResolverExt() {
        super(ModelResolverExt.findMapper());
        this.addPropertyCreator(new BytePropertyCreator());
        this.addPropertyCreator(new ByteArrayPropertyCreator());
        this.addPropertyCreator(new InputStreamPropertyCreator());
        this.addPropertyCreator(new PartPropertyCreator());
        SPIServiceUtils.getAllService(PropertyCreator.class).forEach(this::addPropertyCreator);
        SPIServiceUtils.getAllService(ConcreteTypeRegister.class).forEach(r -> r.register(this.concreteInterfaces));
    }

    private static ObjectMapper findMapper() {
        ModelResolveObjectMapperProvider objectMapperProvider = (ModelResolveObjectMapperProvider)SPIServiceUtils.getPriorityHighestService(ModelResolveObjectMapperProvider.class);
        if (null == objectMapperProvider) {
            objectMapperProvider = new DefaultModelResolveObjectMapperProvider();
        }
        return objectMapperProvider.getMapper();
    }

    private void addPropertyCreator(PropertyCreator creator) {
        for (Class<?> cls : creator.classes()) {
            this.propertyCreatorMap.put(cls, creator);
            this.propertyCreatorMap.put((Type)TypeFactory.defaultInstance().constructType(cls), creator);
        }
    }

    public Schema<?> resolve(AnnotatedType propType, ModelConverterContext context, Iterator<ModelConverter> next) {
        PropertyCreator creator = this.propertyCreatorMap.get(propType.getType());
        if (creator != null) {
            return creator.createProperty();
        }
        if (EnumUtils.isDynamicEnum((Type)propType.getType())) {
            return this.resolveDynamicEnum(TypeFactory.defaultInstance().constructType(propType.getType()));
        }
        Schema result = super.resolve(propType, context, next);
        if (SwaggerGeneratorFeature.isLocalExtJavaClassInVendor() && !StringUtils.isEmpty((CharSequence)result.get$ref())) {
            Schema referencedSchema;
            Schema schema = referencedSchema = context.getDefinedModels() != null ? (Schema)context.getDefinedModels().get(SwaggerUtils.getSchemaName(result.get$ref())) : null;
            if (referencedSchema != null) {
                if (referencedSchema.getExtensions() == null) {
                    referencedSchema.setExtensions(new HashMap());
                }
                if (propType.getType() instanceof JavaType) {
                    referencedSchema.getExtensions().put("x-java-class", ((JavaType)propType.getType()).toCanonical());
                } else {
                    referencedSchema.getExtensions().put("x-java-class", TypeFactory.defaultInstance().constructType(propType.getType()).toCanonical());
                }
            }
        }
        return result;
    }

    private Schema resolveDynamicEnum(JavaType propType) {
        List enums;
        Class enumClass = propType.getRawClass();
        Class enumValueClass = propType.findTypeParameters(DynamicEnum.class)[0].getRawClass();
        Schema property = PrimitiveType.createProperty((Type)enumValueClass);
        if (property instanceof StringSchema) {
            enums = SwaggerEnum.DYNAMIC.readEnumValues(enumClass);
            property.setEnum(enums);
        }
        if (property instanceof NumberSchema) {
            enums = SwaggerEnum.DYNAMIC.readEnumValues(enumClass);
            property.setEnum(enums);
        }
        return property;
    }
}

