/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.bootup;

import java.util.Arrays;
import java.util.Set;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.bootup.BootUpInformationCollector;
import org.apache.servicecomb.core.bootup.ConfigurationProblemsAlarmEvent;
import org.apache.servicecomb.foundation.common.event.AlarmEvent;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.springframework.core.env.Environment;

public class ConfigurationProblemsCollector
implements BootUpInformationCollector {
    @Override
    public String collect(SCBEngine engine) {
        StringBuilder result = new StringBuilder();
        this.collectCsePrefix(engine.getEnvironment(), result);
        this.collectServiceDefinition(engine.getEnvironment(), result);
        this.collectTimeoutConfiguration(engine.getEnvironment(), result);
        if (result.isEmpty()) {
            return null;
        }
        String warnings = "Configurations warnings:\n" + result;
        EventManager.post((Object)((Object)new ConfigurationProblemsAlarmEvent(AlarmEvent.Type.OPEN, warnings)));
        return warnings;
    }

    private void collectTimeoutConfiguration(Environment environment, StringBuilder result) {
        int idleTimeoutInSeconds;
        int keepAliveTimeoutInSeconds = (Integer)environment.getProperty("servicecomb.rest.client.connection.keepAliveTimeoutInSeconds", Integer.TYPE, (Object)60);
        if (keepAliveTimeoutInSeconds >= (idleTimeoutInSeconds = ((Integer)environment.getProperty("servicecomb.rest.client.connection.idleTimeoutInSeconds", Integer.TYPE, (Object)150)).intValue())) {
            result.append("Configuration `servicecomb.rest.client.connection.keepAliveTimeoutInSeconds` is longer than servicecomb.rest.client.connection.idleTimeoutInSeconds.");
            result.append("[").append(keepAliveTimeoutInSeconds).append(",").append(idleTimeoutInSeconds).append("]\n");
        }
        if ((keepAliveTimeoutInSeconds = ((Integer)environment.getProperty("servicecomb.rest.client.http2.connection.keepAliveTimeoutInSeconds", Integer.TYPE, (Object)60)).intValue()) >= (idleTimeoutInSeconds = ((Integer)environment.getProperty("servicecomb.rest.client.http2.connection.idleTimeoutInSeconds", Integer.TYPE, (Object)150)).intValue())) {
            result.append("Configuration `servicecomb.rest.client.http2.connection.keepAliveTimeoutInSeconds` is longer than servicecomb.rest.client.http2.connection.idleTimeoutInSeconds.");
            result.append("[").append(keepAliveTimeoutInSeconds).append(",").append(idleTimeoutInSeconds).append("]\n");
        }
    }

    private void collectServiceDefinition(Environment environment, StringBuilder result) {
        Set names;
        if (environment.getProperty("APPLICATION_ID") != null) {
            result.append("Configurations `APPLICATION_ID` is deprecated, use `servicecomb.service.application` instead.\n");
        }
        if (!(names = ConfigUtil.propertiesWithPrefix((Environment)environment, (String)"service_description.")).isEmpty()) {
            result.append("Configurations with prefix `service_description` is deprecated, use `servicecomb.service` instead. Find keys ");
            result.append(Arrays.toString(names.toArray()));
            result.append("\n");
        }
    }

    private void collectCsePrefix(Environment environment, StringBuilder result) {
        Set names = ConfigUtil.propertiesWithPrefix((Environment)environment, (String)"cse.");
        if (!names.isEmpty()) {
            result.append("Configurations with prefix `cse` is deprecated, use `servicecomb` instead. Find keys ");
            result.append(Arrays.toString(names.toArray()));
            result.append("\n");
        }
    }

    @Override
    public String collect() {
        return null;
    }

    public int getOrder() {
        return 1000;
    }
}

