/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.task;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.http.client.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTask.class);
    protected ExecutorService taskPool;
    private volatile boolean running = true;
    public static AtomicInteger taskCounter = new AtomicInteger(0);

    protected AbstractTask(String taskName) {
        this.initTaskPool(taskName);
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop, taskName + "-shutdown-hook"));
    }

    protected void initTaskPool(String taskName) {
        this.taskPool = Executors.newSingleThreadExecutor(task -> new Thread(task, taskName + "-" + taskCounter.getAndIncrement()));
    }

    protected void startTask(Task task) {
        if (!this.running) {
            return;
        }
        try {
            this.taskPool.execute(() -> {
                try {
                    task.execute();
                }
                catch (Throwable e) {
                    LOGGER.error("unexpected error execute task {}", (Object)task.getClass().getName(), (Object)e);
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOGGER.error("execute task rejected {}", (Object)task.getClass().getName(), (Object)e);
        }
    }

    public void stop() {
        try {
            this.running = false;
            this.taskPool.shutdown();
            this.taskPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("tasks not shutdown in time {}", (Object)e.getMessage());
        }
    }

    public class BackOffSleepTask
    implements Task {
        private static final long BASE = 3000L;
        private static final long MAX = 6000000L;
        long waitTime;
        Task nextTask;

        public BackOffSleepTask(int failedCount, Task nextTask) {
            this.waitTime = (long)(failedCount * failedCount) * 3000L;
            this.nextTask = nextTask;
        }

        public BackOffSleepTask(long waitTime, Task nextTask) {
            this.waitTime = waitTime;
            this.nextTask = nextTask;
        }

        @Override
        public void execute() {
            long time = Math.min(6000000L, this.waitTime);
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e) {
                LOGGER.error("unexpected interrupt during sleep", (Throwable)e);
            }
            AbstractTask.this.startTask(this.nextTask);
        }
    }
}

