/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.discovery;

import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.registry.discovery.InstancePing;
import org.apache.servicecomb.registry.discovery.StatefulDiscoveryInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TelnetInstancePing
implements InstancePing {
    private static final Logger LOGGER = LoggerFactory.getLogger(TelnetInstancePing.class);

    @Override
    public boolean ping(StatefulDiscoveryInstance instance) {
        if (CollectionUtils.isEmpty(instance.getEndpoints())) {
            return false;
        }
        for (String endpoint : instance.getEndpoints()) {
            boolean bl;
            IpPort ipPort = NetUtils.parseIpPortFromURI((String)endpoint);
            Socket s = new Socket();
            try {
                s.connect(new InetSocketAddress(ipPort.getHostOrIp(), ipPort.getPort()), 3000);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("ping instance {}/{}/{}/{} endpoint {} failed", new Object[]{instance.getApplication(), instance.getServiceName(), instance.getRegistryName(), instance.getInstanceId(), endpoint});
                }
            }
            s.close();
            return bl;
        }
        return false;
    }

    public int getOrder() {
        return 10000;
    }
}

