/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.nacos;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.config.DynamicPropertiesSource;
import org.apache.servicecomb.config.nacos.NacosClient;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class NacosDynamicPropertiesSource
implements DynamicPropertiesSource {
    public static final String SOURCE_NAME = "nacos";
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosDynamicPropertiesSource.class);
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>();
    private final UpdateHandler updateHandler = new UpdateHandler();

    private void init(Environment environment) {
        NacosClient nacosClient = new NacosClient(this.updateHandler, environment);
        try {
            nacosClient.refreshNacosConfig();
        }
        catch (Exception e) {
            throw new IllegalStateException("Set up nacos config failed.", e);
        }
    }

    public MapPropertySource create(Environment environment) {
        this.init(environment);
        return new MapPropertySource(SOURCE_NAME, this.valueCache);
    }

    public int getOrder() {
        return 0;
    }

    public class UpdateHandler {
        public void handle(Map<String, Object> current, Map<String, Object> last) {
            ConfigurationChangedEvent event = ConfigurationChangedEvent.createIncremental(current, last);
            LOGGER.info("Dynamic configuration changed: {}", (Object)event.getChanged());
            NacosDynamicPropertiesSource.this.valueCache.putAll(event.getAdded());
            NacosDynamicPropertiesSource.this.valueCache.putAll(event.getUpdated());
            event.getDeleted().forEach((k, v) -> NacosDynamicPropertiesSource.this.valueCache.remove(k));
            EventManager.post((Object)event);
        }
    }
}

