/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.priority.PriorityPropertyManager;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.SCBStatus;
import org.apache.servicecomb.core.bootup.BootUpInformationCollector;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceVersionsMeta;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.core.executor.ExecutorManager;
import org.apache.servicecomb.core.filter.FilterChainsManager;
import org.apache.servicecomb.core.provider.OpenAPIRegistryManager;
import org.apache.servicecomb.core.provider.consumer.ConsumerProviderManager;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfigManager;
import org.apache.servicecomb.core.provider.producer.ProducerProviderManager;
import org.apache.servicecomb.core.transport.TransportManager;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.swagger.engine.SwaggerEnvironment;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class SCBEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCBEngine.class);
    public static final String CFG_KEY_TURN_DOWN_STATUS_WAIT_SEC = "servicecomb.boot.turnDown.waitInSeconds";
    public static final long DEFAULT_TURN_DOWN_STATUS_WAIT_SEC = 0L;
    private static volatile SCBEngine INSTANCE;
    private ApplicationContext applicationContext;
    private FilterChainsManager filterChainsManager;
    private ProducerProviderManager producerProviderManager;
    private ConsumerProviderManager consumerProviderManager;
    private MicroserviceMeta producerMicroserviceMeta;
    private TransportManager transportManager;
    private List<BootListener> bootListeners;
    private final AtomicLong invocationStartedCounter = new AtomicLong();
    private final AtomicLong invocationFinishedCounter = new AtomicLong();
    private volatile SCBStatus status = SCBStatus.DOWN;
    private final EventBus eventBus;
    private ExecutorManager executorManager;
    private PriorityPropertyManager priorityPropertyManager;
    private List<BootUpInformationCollector> bootUpInformationCollectors;
    private final SwaggerEnvironment swaggerEnvironment = new SwaggerEnvironment();
    private OpenAPIRegistryManager openAPIRegistryManager;
    private RegistrationManager registrationManager;
    private DiscoveryManager discoveryManager;
    private Environment environment;
    private ReferenceConfigManager referenceConfigManager;

    public SCBEngine() {
        this.eventBus = EventManager.getEventBus();
        this.eventBus.register((Object)this);
        INSTANCE = this;
        this.producerProviderManager = new ProducerProviderManager(this);
    }

    public static SCBEngine getInstance() {
        if (INSTANCE == null) {
            throw new InvocationException((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, (Object)new CommonExceptionData("SCBEngine is not initialized yet."));
        }
        return INSTANCE;
    }

    @Autowired
    public void setReferenceConfigManager(ReferenceConfigManager referenceConfigManager) {
        this.referenceConfigManager = referenceConfigManager;
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    @Autowired
    public void setBootUpInformationCollectors(List<BootUpInformationCollector> bootUpInformationCollectors) {
        this.bootUpInformationCollectors = bootUpInformationCollectors;
    }

    @Autowired
    public void setBootListeners(List<BootListener> listeners) {
        this.bootListeners = listeners;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Autowired
    public void setRegistrationManager(RegistrationManager registrationManager) {
        this.registrationManager = registrationManager;
    }

    @Autowired
    public void setDiscoveryManager(DiscoveryManager discoveryManager) {
        this.discoveryManager = discoveryManager;
    }

    @Autowired
    public void setOpenAPIRegistryManager(OpenAPIRegistryManager openAPIRegistryManager) {
        this.openAPIRegistryManager = openAPIRegistryManager;
    }

    @Autowired
    public void setConsumerProviderManager(ConsumerProviderManager consumerProviderManager) {
        this.consumerProviderManager = consumerProviderManager;
    }

    @Autowired
    public void setExecutorManager(ExecutorManager executorManager) {
        this.executorManager = executorManager;
    }

    @Autowired
    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public RegistrationManager getRegistrationManager() {
        return this.registrationManager;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getAppId() {
        return BootStrapProperties.readApplication((Environment)this.environment);
    }

    public void setStatus(SCBStatus status) {
        this.status = status;
    }

    public SCBStatus getStatus() {
        return this.status;
    }

    public OpenAPIRegistryManager getOpenAPIRegistryManager() {
        return this.openAPIRegistryManager;
    }

    public FilterChainsManager getFilterChainsManager() {
        return this.filterChainsManager;
    }

    public SCBEngine setFilterChainsManager(FilterChainsManager filterChainsManager) {
        this.filterChainsManager = filterChainsManager;
        return this;
    }

    public PriorityPropertyManager getPriorityPropertyManager() {
        return this.priorityPropertyManager;
    }

    public SCBEngine setPriorityPropertyManager(PriorityPropertyManager priorityPropertyManager) {
        this.priorityPropertyManager = priorityPropertyManager;
        return this;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public ExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    public ProducerProviderManager getProducerProviderManager() {
        return this.producerProviderManager;
    }

    public void setProducerProviderManager(ProducerProviderManager producerProviderManager) {
        this.producerProviderManager = producerProviderManager;
    }

    public ConsumerProviderManager getConsumerProviderManager() {
        return this.consumerProviderManager;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public SwaggerEnvironment getSwaggerEnvironment() {
        return this.swaggerEnvironment;
    }

    public SCBEngine addProducerMeta(String schemaId, Object instance) {
        this.getProducerProviderManager().addProducerMeta(schemaId, instance);
        return this;
    }

    protected void triggerEvent(BootListener.EventType eventType) {
        BootListener.BootEvent event = new BootListener.BootEvent();
        event.setScbEngine(this);
        event.setEventType(eventType);
        for (BootListener listener : this.bootListeners) {
            listener.onBootEvent(event);
        }
    }

    protected void safeTriggerEvent(BootListener.EventType eventType) {
        BootListener.BootEvent event = new BootListener.BootEvent();
        event.setScbEngine(this);
        event.setEventType(eventType);
        for (BootListener listener : this.bootListeners) {
            try {
                listener.onBootEvent(event);
                LOGGER.info("BootListener {} succeed to process {}.", (Object)listener.getClass().getName(), (Object)eventType);
            }
            catch (Throwable e) {
                LOGGER.error("BootListener {} failed to process {}.", new Object[]{listener.getClass().getName(), eventType, e});
            }
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onInvocationStart(InvocationStartEvent event) {
        this.invocationStartedCounter.incrementAndGet();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onInvocationFinish(InvocationFinishEvent event) {
        this.invocationFinishedCounter.incrementAndGet();
    }

    public synchronized SCBEngine init() {
        this.discoveryManager.init();
        this.registrationManager.init();
        return this;
    }

    public synchronized SCBEngine run() {
        if (SCBStatus.DOWN.equals((Object)this.status)) {
            try {
                this.doRun();
                this.printServiceInfo();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to start ServiceComb due to errors and close", e);
                try {
                    this.destroy();
                }
                catch (Exception exception) {
                    LOGGER.info("destroy has some error.", (Throwable)exception);
                }
                this.status = SCBStatus.FAILED;
                throw new IllegalStateException("ServiceComb init failed.", e);
            }
        }
        return this;
    }

    private void printServiceInfo() {
        StringBuilder serviceInfo = new StringBuilder();
        serviceInfo.append("Service information is shown below:\n");
        for (BootUpInformationCollector bootUpInformationCollector : this.bootUpInformationCollectors) {
            String info = bootUpInformationCollector.collect(this);
            if (StringUtils.isEmpty((CharSequence)info)) continue;
            serviceInfo.append(info);
            if (info.endsWith("\n")) continue;
            serviceInfo.append('\n');
        }
        LOGGER.info(serviceInfo.toString());
    }

    private void doRun() throws Exception {
        this.status = SCBStatus.STARTING;
        this.triggerEvent(BootListener.EventType.BEFORE_FILTER);
        this.filterChainsManager.init();
        this.triggerEvent(BootListener.EventType.AFTER_FILTER);
        this.createProducerMicroserviceMeta();
        this.triggerEvent(BootListener.EventType.BEFORE_PRODUCER_PROVIDER);
        this.producerProviderManager.init();
        this.triggerEvent(BootListener.EventType.AFTER_PRODUCER_PROVIDER);
        this.triggerEvent(BootListener.EventType.BEFORE_CONSUMER_PROVIDER);
        this.consumerProviderManager.init();
        this.triggerEvent(BootListener.EventType.AFTER_CONSUMER_PROVIDER);
        this.triggerEvent(BootListener.EventType.BEFORE_TRANSPORT);
        this.transportManager.init(this);
        this.triggerEvent(BootListener.EventType.AFTER_TRANSPORT);
        this.triggerEvent(BootListener.EventType.BEFORE_REGISTRY);
        this.registrationManager.run();
        this.discoveryManager.run();
        this.registrationManager.updateMicroserviceInstanceStatus(MicroserviceInstanceStatus.UP);
        this.status = SCBStatus.UP;
        this.triggerEvent(BootListener.EventType.AFTER_REGISTRY);
        LOGGER.warn("ServiceComb is ready.");
    }

    private void createProducerMicroserviceMeta() {
        String microserviceName = BootStrapProperties.readServiceName((Environment)this.environment);
        this.producerMicroserviceMeta = new MicroserviceMeta(this, BootStrapProperties.readApplication((Environment)this.environment), microserviceName, false);
        this.producerMicroserviceMeta.setProviderFilterChain(this.filterChainsManager.findProducerChain(BootStrapProperties.readApplication((Environment)this.environment), microserviceName));
        this.producerMicroserviceMeta.setMicroserviceVersionsMeta(new MicroserviceVersionsMeta(this));
    }

    public synchronized void destroy() {
        if (SCBStatus.UP.equals((Object)this.status) || SCBStatus.STARTING.equals((Object)this.status)) {
            LOGGER.info("ServiceComb is closing now...");
            this.doDestroy();
            this.status = SCBStatus.DOWN;
            LOGGER.info("ServiceComb had closed");
        }
    }

    private void doDestroy() {
        this.turnDownInstanceStatus();
        this.blockShutDownOperationForConsumerRefresh();
        this.safeTriggerEvent(BootListener.EventType.BEFORE_CLOSE);
        this.status = SCBStatus.STOPPING;
        this.registrationManager.destroy();
        this.discoveryManager.destroy();
        try {
            this.validAllInvocationFinished();
        }
        catch (InterruptedException e) {
            LOGGER.error("wait all invocation finished interrupted", (Throwable)e);
        }
        if (this.priorityPropertyManager != null) {
            this.priorityPropertyManager.close();
        }
        VertxUtils.blockCloseVertxByName((String)"transport");
        HttpClients.destroy();
        this.safeTriggerEvent(BootListener.EventType.AFTER_CLOSE);
    }

    private void turnDownInstanceStatus() {
        try {
            this.registrationManager.updateMicroserviceInstanceStatus(MicroserviceInstanceStatus.DOWN);
        }
        catch (Throwable e) {
            LOGGER.warn("turn down instance status fail: {}", (Object)e.getMessage());
        }
    }

    private void blockShutDownOperationForConsumerRefresh() {
        try {
            long turnDownWaitSeconds = (Long)this.environment.getProperty(CFG_KEY_TURN_DOWN_STATUS_WAIT_SEC, Long.TYPE, (Object)0L);
            if (turnDownWaitSeconds <= 0L) {
                return;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(turnDownWaitSeconds));
        }
        catch (InterruptedException e) {
            LOGGER.warn("failed to block the shutdown procedure", (Throwable)e);
        }
    }

    private void validAllInvocationFinished() throws InterruptedException {
        long start = System.currentTimeMillis();
        long remaining;
        while ((remaining = this.invocationStartedCounter.get() - this.invocationFinishedCounter.get()) > 0L) {
            if (System.currentTimeMillis() - start > TimeUnit.SECONDS.toMillis(30L)) {
                LOGGER.error("wait for all requests timeout, abandon waiting, remaining requests: {}.", (Object)remaining);
                return;
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        return;
    }

    public void ensureStatusUp() {
        SCBStatus currentStatus = this.getStatus();
        if (!SCBStatus.UP.equals((Object)currentStatus)) {
            String message = "The request is rejected. Cannot process the request due to STATUS = " + currentStatus;
            throw new InvocationException((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, (Object)new CommonExceptionData(message));
        }
    }

    public CompletableFuture<MicroserviceReferenceConfig> getOrCreateReferenceConfigAsync(String microserviceName) {
        return this.referenceConfigManager.getOrCreateReferenceConfigAsync(this, microserviceName);
    }

    public MicroserviceReferenceConfig getOrCreateReferenceConfig(String microserviceName) {
        this.ensureStatusUp();
        return this.referenceConfigManager.getOrCreateReferenceConfig(this, microserviceName);
    }

    public MicroserviceMeta getProducerMicroserviceMeta() {
        return this.producerMicroserviceMeta;
    }

    public void setProducerMicroserviceMeta(MicroserviceMeta producerMicroserviceMeta) {
        this.producerMicroserviceMeta = producerMicroserviceMeta;
    }

    public static class CreateMicroserviceMetaEvent {
        private final MicroserviceMeta microserviceMeta;

        public CreateMicroserviceMetaEvent(MicroserviceMeta microserviceMeta) {
            this.microserviceMeta = microserviceMeta;
        }

        public MicroserviceMeta getMicroserviceMeta() {
            return this.microserviceMeta;
        }
    }
}

