/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import io.github.resilience4j.core.metrics.Metrics;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.governance.RetryContext;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ExtensionsManager;
import org.apache.servicecomb.loadbalance.LoadBalancer;
import org.apache.servicecomb.loadbalance.RuleExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTree;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LoadBalanceFilter
extends AbstractFilter
implements ConsumerFilter,
EdgeFilter {
    public static final String CONTEXT_KEY_LAST_SERVER = "x-context-last-server";
    private static final int COUNT = 17;
    public static final String CONTEXT_KEY_SERVER_LIST = "x-context-server-list";
    public static final String SERVICECOMB_SERVER_ENDPOINT = "scb-endpoint";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalanceFilter.class);
    private final DiscoveryTree discoveryTree;
    private final Map<String, LoadBalancer> loadBalancerMap = new ConcurrentHashMapEx();
    private final Object lock = new Object();
    private final ExtensionsManager extensionsManager;
    private final SCBEngine scbEngine;
    public boolean supportDefinedEndpoint;

    @Autowired
    public LoadBalanceFilter(ExtensionsManager extensionsManager, DiscoveryTree discoveryTree, SCBEngine scbEngine) {
        this.preCheck(scbEngine);
        this.scbEngine = scbEngine;
        this.supportDefinedEndpoint = (Boolean)this.scbEngine.getEnvironment().getProperty("servicecomb.loadbalance.userDefinedEndpoint.enabled", Boolean.TYPE, (Object)false);
        this.extensionsManager = extensionsManager;
        this.discoveryTree = discoveryTree;
        EventManager.register((Object)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        Set changedKeys = event.getChanged();
        for (String key : changedKeys) {
            if (!key.startsWith("servicecomb.loadbalance.")) continue;
            Object object = this.lock;
            synchronized (object) {
                this.clearLoadBalancer();
            }
            LOGGER.info("clear load balance rule for configuration changed, {}", (Object)key);
            break;
        }
    }

    private void preCheck(SCBEngine scbEngine) {
        String filterNames;
        String policyName = scbEngine.getEnvironment().getProperty("servicecomb.loadbalance.NFLoadBalancerRuleClassName");
        if (!StringUtils.isEmpty((CharSequence)policyName)) {
            LOGGER.error("[servicecomb.loadbalance.NFLoadBalancerRuleClassName] is not supported anymore.use [servicecomb.loadbalance.strategy.name] instead.");
        }
        if (!StringUtils.isEmpty((CharSequence)(filterNames = scbEngine.getEnvironment().getProperty("servicecomb.loadbalance.serverListFilters")))) {
            LOGGER.error("Server list implementation changed to SPI. Configuration [servicecomb.loadbalance.serverListFilters] is not used any more. For ServiceComb defined filters, you do not need config and can remove this configuration safely. If you define your own filter, need to change it to SPI to make it work.");
        }
    }

    public int getOrder() {
        return 0;
    }

    public String getName() {
        return "load-balance";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        try {
            if (this.handleSuppliedEndpoint(invocation)) {
                invocation.addLocalContext("x-context-retry-loadbalance", (Object)false);
                return nextNode.onFilter(invocation);
            }
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        invocation.addLocalContext("x-context-retry-loadbalance", (Object)true);
        LoadBalancer loadBalancer = this.getOrCreateLoadBalancer(invocation);
        return this.send(invocation, nextNode, loadBalancer);
    }

    private boolean handleSuppliedEndpoint(Invocation invocation) throws Exception {
        if (invocation.getEndpoint() != null) {
            return true;
        }
        if (this.supportDefinedEndpoint) {
            return this.defineEndpointAndHandle(invocation);
        }
        return false;
    }

    private Endpoint parseEndpoint(String endpointUri) throws Exception {
        URI formatUri = new URI(endpointUri);
        Transport transport = this.scbEngine.getTransportManager().findTransport(formatUri.getScheme());
        if (transport == null) {
            LOGGER.error("not deployed transport {}, ignore {}.", (Object)formatUri.getScheme(), (Object)endpointUri);
            throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "the endpoint's transport is not found.");
        }
        return new Endpoint(transport, endpointUri);
    }

    private boolean defineEndpointAndHandle(Invocation invocation) throws Exception {
        Object endpoint = invocation.getLocalContext(SERVICECOMB_SERVER_ENDPOINT);
        if (endpoint == null) {
            return false;
        }
        if (endpoint instanceof String) {
            endpoint = this.parseEndpoint((String)endpoint);
        }
        invocation.setEndpoint((Endpoint)endpoint);
        return true;
    }

    private void clearLoadBalancer() {
        this.loadBalancerMap.clear();
    }

    @VisibleForTesting
    CompletableFuture<Response> send(Invocation invocation, FilterNode filterNode, LoadBalancer chosenLB) {
        long time = System.currentTimeMillis();
        ServiceCombServer server = this.chooseServer(invocation, chosenLB);
        if (null == server) {
            return CompletableFuture.failedFuture((Throwable)new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, String.format("No available address found for %s/%s.", invocation.getAppId(), invocation.getMicroserviceName())));
        }
        invocation.setEndpoint(server.getEndpoint());
        return filterNode.onFilter(invocation).whenComplete((r, e) -> {
            if (e != null || this.isFailedResponse((Response)r)) {
                server.getServerMetrics().record(System.currentTimeMillis() - time, TimeUnit.MILLISECONDS, Metrics.Outcome.ERROR);
            } else {
                server.getServerMetrics().record(System.currentTimeMillis() - time, TimeUnit.MILLISECONDS, Metrics.Outcome.SUCCESS);
            }
        });
    }

    private ServiceCombServer chooseServer(Invocation invocation, LoadBalancer chosenLB) {
        ServiceCombServer lastServer;
        RetryContext retryContext = (RetryContext)invocation.getLocalContext("x-context-retry");
        if (retryContext == null) {
            return chosenLB.chooseServer(invocation);
        }
        if (!retryContext.isRetry()) {
            ServiceCombServer server = chosenLB.chooseServer(invocation);
            invocation.addLocalContext(CONTEXT_KEY_LAST_SERVER, (Object)server);
            return server;
        }
        ServiceCombServer nextServer = lastServer = (ServiceCombServer)invocation.getLocalContext(CONTEXT_KEY_LAST_SERVER);
        if (!retryContext.trySameServer()) {
            ServiceCombServer s;
            for (int i = 0; i < 17 && (s = chosenLB.chooseServer(invocation)) != null; ++i) {
                if (s.equals(nextServer)) continue;
                nextServer = s;
                break;
            }
        }
        LOGGER.warn("operation failed {}, retry to instance [{}], last instance [{}], trace id {}", new Object[]{invocation.getMicroserviceQualifiedName(), nextServer == null ? "" : nextServer.getEndpoint().getEndpoint(), lastServer == null ? "" : nextServer.getEndpoint().getEndpoint(), invocation.getTraceId()});
        invocation.addLocalContext(CONTEXT_KEY_LAST_SERVER, (Object)nextServer);
        return nextServer;
    }

    protected boolean isFailedResponse(Response resp) {
        if (resp.isFailed()) {
            if (resp.getResult() instanceof InvocationException) {
                InvocationException e = (InvocationException)resp.getResult();
                return e.getStatusCode() == 490 || e.getStatusCode() == Response.Status.SERVICE_UNAVAILABLE.getStatusCode() || e.getStatusCode() == Response.Status.REQUEST_TIMEOUT.getStatusCode();
            }
            return true;
        }
        return false;
    }

    protected LoadBalancer getOrCreateLoadBalancer(Invocation invocation) {
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)invocation);
        DiscoveryTreeNode serversVersionedCache = this.discoveryTree.discovery(context, invocation.getAppId(), invocation.getMicroserviceName());
        invocation.addLocalContext(CONTEXT_KEY_SERVER_LIST, serversVersionedCache.data());
        Configuration.RuleType ruleType = Configuration.INSTANCE.getRuleStrategyName(invocation);
        String cacheKey = ruleType.getType() == 1 ? invocation.getAppId() + "-" + invocation.getMicroserviceName() + "-" + invocation.getSchemaId() : invocation.getAppId() + "-" + invocation.getMicroserviceName() + "-" + invocation.getSchemaId() + "-" + invocation.getOperationName();
        return this.loadBalancerMap.computeIfAbsent(cacheKey, key -> this.createLoadBalancer(ruleType, (String)key, invocation.getMicroserviceName()));
    }

    private LoadBalancer createLoadBalancer(Configuration.RuleType ruleType, String cacheKey, String microserviceName) {
        RuleExt rule = this.extensionsManager.createLoadBalancerRule(ruleType.getValue());
        LOGGER.info("Using load balance rule {} for microservice {}.", (Object)rule.getClass().getName(), (Object)cacheKey);
        return new LoadBalancer(rule, microserviceName);
    }
}

