/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.distribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.servicecomb.router.cache.RouterRuleCache;
import org.apache.servicecomb.router.distribute.RouterDistributor;
import org.apache.servicecomb.router.model.PolicyRuleItem;
import org.apache.servicecomb.router.model.RouteItem;
import org.apache.servicecomb.router.model.TagItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractRouterDistributor<INSTANCE>
implements RouterDistributor<INSTANCE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRouterDistributor.class);
    private Function<INSTANCE, String> getVersion;
    private Function<INSTANCE, String> getServerName;
    private Function<INSTANCE, Map<String, String>> getProperties;
    private RouterRuleCache routerRuleCache;

    @Autowired
    public void setRouterRuleCache(RouterRuleCache routerRuleCache) {
        this.routerRuleCache = routerRuleCache;
    }

    protected AbstractRouterDistributor() {
    }

    @Override
    public List<INSTANCE> distribute(String targetServiceName, List<INSTANCE> list, PolicyRuleItem invokeRule) {
        TagItem fallbackTargetTag;
        invokeRule.check();
        ArrayList unSetTagInstances = new ArrayList();
        HashMap<TagItem, List<INSTANCE>> fallbackVersionServerMap = new HashMap<TagItem, List<INSTANCE>>();
        Map<TagItem, List<INSTANCE>> versionServerMap = this.getDistributList(targetServiceName, list, invokeRule, unSetTagInstances, fallbackVersionServerMap);
        TagItem targetTag = this.getFiltedServerTagItem(invokeRule, targetServiceName);
        if (targetTag != null && versionServerMap.containsKey(targetTag)) {
            return versionServerMap.get(targetTag);
        }
        if (!fallbackVersionServerMap.isEmpty() && (fallbackTargetTag = this.getFallbackFiltedServerTagItem(invokeRule, targetServiceName)) != null && fallbackVersionServerMap.containsKey(fallbackTargetTag)) {
            return (List)fallbackVersionServerMap.get(fallbackTargetTag);
        }
        if (invokeRule.isWeightLess() && !unSetTagInstances.isEmpty()) {
            return unSetTagInstances;
        }
        return list;
    }

    @Override
    public void init(Function<INSTANCE, String> getVersion, Function<INSTANCE, String> getServerName, Function<INSTANCE, Map<String, String>> getProperties) {
        this.getVersion = getVersion;
        this.getServerName = getServerName;
        this.getProperties = getProperties;
    }

    public TagItem getFiltedServerTagItem(PolicyRuleItem rule, String targetServiceName) {
        return this.routerRuleCache.getServiceInfoCacheMap().get(targetServiceName).getNextInvokeVersion(rule);
    }

    public TagItem getFallbackFiltedServerTagItem(PolicyRuleItem rule, String targetServiceName) {
        return this.routerRuleCache.getServiceInfoCacheMap().get(targetServiceName).getFallbackNextInvokeVersion(rule);
    }

    private Map<TagItem, List<INSTANCE>> getDistributList(String serviceName, List<INSTANCE> list, PolicyRuleItem invokeRule, List<INSTANCE> unSetTagInstances, Map<TagItem, List<INSTANCE>> fallbackVersionMap) {
        HashMap<TagItem, List<INSTANCE>> versionServerMap = new HashMap<TagItem, List<INSTANCE>>();
        for (INSTANCE instance : list) {
            if (!this.getServerName.apply(instance).equals(serviceName)) continue;
            TagItem tagItem = new TagItem(this.getVersion.apply(instance), this.getProperties.apply(instance));
            TagItem targetTag = this.buildTargetTag(invokeRule.getRoute(), tagItem);
            if (targetTag != null) {
                if (!versionServerMap.containsKey(targetTag)) {
                    versionServerMap.put(targetTag, new ArrayList());
                }
                ((List)versionServerMap.get(targetTag)).add(instance);
            } else {
                unSetTagInstances.add(instance);
            }
            if (CollectionUtils.isEmpty(invokeRule.getFallback())) continue;
            TagItem targetTagFallback = this.buildTargetTag(invokeRule.getFallback(), tagItem);
            if (!fallbackVersionMap.containsKey(targetTagFallback)) {
                fallbackVersionMap.put(targetTagFallback, new ArrayList());
            }
            fallbackVersionMap.get(targetTagFallback).add(instance);
        }
        return versionServerMap;
    }

    private TagItem buildTargetTag(List<RouteItem> route, TagItem tagItem) {
        int maxMatch = 0;
        TagItem targetTag = null;
        for (RouteItem entry : route) {
            int nowMatch;
            if (entry.getTagitem() == null || (nowMatch = entry.getTagitem().matchNum(tagItem)) <= maxMatch) continue;
            maxMatch = nowMatch;
            targetTag = entry.getTagitem();
        }
        return targetTag;
    }
}

