/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.sc;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.event.SimpleEventBus;
import org.apache.servicecomb.registry.api.Discovery;
import org.apache.servicecomb.registry.sc.SCConfigurationProperties;
import org.apache.servicecomb.registry.sc.SCDiscoveryInstance;
import org.apache.servicecomb.registry.sc.SCRegistration;
import org.apache.servicecomb.service.center.client.DiscoveryEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.ServiceCenterDiscovery;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class SCDiscovery
implements Discovery<SCDiscoveryInstance> {
    public static final String SC_DISCOVERY_ENABLED = "servicecomb.registry.sc.%s.%s.enabled";
    private final EventBus eventBus = new SimpleEventBus();
    private final SCConfigurationProperties configurationProperties;
    private final ServiceCenterClient serviceCenterClient;
    private SCRegistration scRegistration;
    private ServiceCenterDiscovery serviceCenterDiscovery;
    private Discovery.InstanceChangedListener<SCDiscoveryInstance> instanceChangedListener;
    private Environment environment;

    @Autowired
    public SCDiscovery(SCConfigurationProperties configurationProperties, ServiceCenterClient serviceCenterClient) {
        this.configurationProperties = configurationProperties;
        this.serviceCenterClient = serviceCenterClient;
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Autowired
    public void setScRegistration(SCRegistration scRegistration) {
        this.scRegistration = scRegistration;
    }

    public String name() {
        return "sc-registry";
    }

    public int getOrder() {
        return -9000;
    }

    public boolean enabled(String application, String serviceName) {
        return (Boolean)this.environment.getProperty(String.format(SC_DISCOVERY_ENABLED, application, serviceName), Boolean.TYPE, (Object)true);
    }

    public List<SCDiscoveryInstance> findServiceInstances(String application, String serviceName) {
        ServiceCenterDiscovery.SubscriptionKey subscriptionKey = new ServiceCenterDiscovery.SubscriptionKey(application, serviceName);
        this.serviceCenterDiscovery.registerIfNotPresent(subscriptionKey);
        List instances = this.serviceCenterDiscovery.getInstanceCache(subscriptionKey);
        return this.toDiscoveryInstances(instances);
    }

    private List<SCDiscoveryInstance> toDiscoveryInstances(List<MicroserviceInstance> instances) {
        Map schemaResult;
        if (CollectionUtils.isEmpty(instances)) {
            return Collections.emptyList();
        }
        if (this.configurationProperties.isEnableSwaggerRegistration()) {
            List schemas = this.serviceCenterClient.getServiceSchemasList(instances.get(0).getServiceId(), true);
            if (schemas == null) {
                schemaResult = Collections.emptyMap();
            } else {
                schemaResult = new HashMap(schemas.size());
                schemas.forEach(info -> schemaResult.put(info.getSchemaId(), info.getSchema()));
            }
        } else {
            schemaResult = new HashMap();
        }
        ArrayList<SCDiscoveryInstance> result = new ArrayList<SCDiscoveryInstance>(instances.size());
        instances.forEach(instance -> result.add(new SCDiscoveryInstance((MicroserviceInstance)instance, schemaResult)));
        return result;
    }

    public void setInstanceChangedListener(Discovery.InstanceChangedListener<SCDiscoveryInstance> instanceChangedListener) {
        this.instanceChangedListener = instanceChangedListener;
    }

    @Subscribe
    public void onInstanceChangedEvent(DiscoveryEvents.InstanceChangedEvent event) {
        this.instanceChangedListener.onInstanceChanged(this.name(), event.getAppName(), event.getServiceName(), this.toDiscoveryInstances(event.getInstances()));
    }

    public void init() {
        this.serviceCenterDiscovery = new ServiceCenterDiscovery(this.serviceCenterClient, this.eventBus);
        this.serviceCenterDiscovery.setPollInterval((long)this.configurationProperties.getPollIntervalInMillis());
        this.eventBus.register((Object)this);
    }

    public void run() {
        this.serviceCenterDiscovery.updateMyselfServiceId(this.scRegistration.getBackendMicroservice().getServiceId());
        this.serviceCenterDiscovery.startDiscovery();
    }

    public void destroy() {
        if (this.serviceCenterDiscovery != null) {
            this.serviceCenterDiscovery.stop();
        }
    }

    public boolean enabled() {
        return this.configurationProperties.isEnabled();
    }
}

