/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.qps.Config;
import org.apache.servicecomb.qps.QpsConst;
import org.apache.servicecomb.qps.QpsControllerManager;
import org.apache.servicecomb.qps.QpsStrategy;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.core.env.Environment;

public class ConsumerFlowControlFilter
extends AbstractFilter
implements ConsumerFilter,
EdgeFilter {
    private final QpsControllerManager qpsControllerMgr;

    public ConsumerFlowControlFilter(Environment environment) {
        this.qpsControllerMgr = new QpsControllerManager(false, environment);
    }

    @VisibleForTesting
    public QpsControllerManager getQpsControllerMgr() {
        return this.qpsControllerMgr;
    }

    public int getOrder() {
        return -1990;
    }

    public String getName() {
        return "consumer-flow-control";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (!Config.INSTANCE.isConsumerEnabled()) {
            return nextNode.onFilter(invocation);
        }
        QpsStrategy qpsStrategy = this.qpsControllerMgr.getOrCreate(invocation.getMicroserviceName(), invocation);
        if (qpsStrategy.isLimitNewRequest()) {
            CommonExceptionData errorData = new CommonExceptionData("consumer request rejected by flow control.");
            return CompletableFuture.failedFuture((Throwable)new InvocationException(QpsConst.TOO_MANY_REQUESTS_STATUS, (Object)errorData));
        }
        return nextNode.onFilter(invocation);
    }
}

