/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter.inner;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.MultiMap;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.HttpTransportContext;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessorManager;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.TransportContext;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServerCodecFilter
extends AbstractFilter
implements ProviderFilter,
EdgeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServerCodecFilter.class);
    public static final String NAME = "rest-server-codec";

    public String getName() {
        return NAME;
    }

    public int getOrder() {
        return -2000;
    }

    public boolean enabledForTransport(String transport) {
        return "rest".equals(transport);
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(invocation).thenAccept(this::decodeRequest)).thenCompose(v -> this.invokeNext(invocation, nextNode))).exceptionally(exception -> Exceptions.toProducerResponse((Invocation)invocation, (Throwable)exception))).thenCompose(response -> this.encodeResponse(invocation, (Response)response));
    }

    protected CompletableFuture<Response> invokeNext(Invocation invocation, FilterNode nextNode) {
        if (invocation.isEdge()) {
            TransportContext transportContext = invocation.getTransportContext();
            return nextNode.onFilter(invocation).whenComplete((r, e) -> invocation.setTransportContext(transportContext));
        }
        return nextNode.onFilter(invocation);
    }

    protected void decodeRequest(Invocation invocation) {
        invocation.getInvocationStageTrace().startProviderDecodeRequest();
        HttpServletRequestEx requestEx = invocation.getRequestEx();
        OperationMeta operationMeta = invocation.getOperationMeta();
        RestOperationMeta restOperationMeta = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        Map<String, Object> swaggerArguments = RestCodec.restToArgs((HttpServletRequest)requestEx, restOperationMeta);
        invocation.setSwaggerArguments(swaggerArguments);
        invocation.getInvocationStageTrace().finishProviderDecodeRequest();
    }

    protected CompletableFuture<Response> encodeResponse(Invocation invocation, Response response) {
        invocation.onEncodeResponseStart(response);
        HttpTransportContext transportContext = (HttpTransportContext)invocation.getTransportContext();
        ProduceProcessor produceProcessor = ProduceProcessorManager.INSTANCE.createProduceProcessor(invocation.getOperationMeta(), response.getStatusCode(), invocation.getRequestEx().getHeader("Accept"), null);
        HttpServletResponseEx responseEx = transportContext.getResponseEx();
        boolean download = RestServerCodecFilter.isDownloadFileResponseType(invocation, response);
        return RestServerCodecFilter.encodeResponse(response, download, produceProcessor, responseEx).whenComplete((r, e) -> invocation.onEncodeResponseFinish());
    }

    public static CompletableFuture<Response> encodeResponse(Response response, boolean download, ProduceProcessor produceProcessor, HttpServletResponseEx responseEx) {
        CompletableFuture<Response> completableFuture;
        responseEx.setStatus(response.getStatusCode());
        RestServerCodecFilter.copyHeadersToHttpResponse(response.getHeaders(), responseEx);
        if (download) {
            return CompletableFuture.completedFuture(response);
        }
        responseEx.setContentType(produceProcessor.getName());
        BufferOutputStream output = new BufferOutputStream((ByteBuf)Unpooled.compositeBuffer());
        try {
            produceProcessor.encodeResponse((OutputStream)output, response.getResult());
            responseEx.setBodyBuffer(output.getBuffer());
            completableFuture = CompletableFuture.completedFuture(response);
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                CompletableFuture<Response> completableFuture2;
                LOGGER.error("internal service error must be fixed.", e);
                BufferOutputStream output2 = new BufferOutputStream((ByteBuf)Unpooled.compositeBuffer());
                try {
                    responseEx.setStatus(500);
                    produceProcessor.encodeResponse((OutputStream)output2, new CommonExceptionData("500", "Internal Server Error"));
                    responseEx.setBodyBuffer(output2.getBuffer());
                    completableFuture2 = CompletableFuture.completedFuture(response);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            output2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    catch (Throwable e1) {
                        return AsyncUtils.completeExceptionally((Throwable)e);
                    }
                }
                output2.close();
                return completableFuture2;
            }
        }
        output.close();
        return completableFuture;
    }

    public static boolean isDownloadFileResponseType(Invocation invocation, Response response) {
        return Part.class.isAssignableFrom(invocation.findResponseType(response.getStatusCode()).getRawClass());
    }

    public static void copyHeadersToHttpResponse(MultiMap headers, HttpServletResponseEx responseEx) {
        if (headers == null) {
            return;
        }
        headers.remove("Content-Length");
        headers.remove("Transfer-Encoding");
        for (Map.Entry entry : headers.entries()) {
            responseEx.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

