/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.inject.util.Types;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.converter.Converter;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class FormProcessorCreator
implements ParamValueProcessorCreator<RequestBody> {
    public static final String PARAMTYPE = "formData";

    public FormProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(OperationMeta operationMeta, String paramName, RequestBody parameter, Type genericParamType) {
        JavaType targetType;
        JavaType javaType = targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        if (this.isPart(parameter, paramName)) {
            return new PartProcessor(paramName, parameter, genericParamType);
        }
        String mediaType = "application/x-www-form-urlencoded";
        if (parameter.getContent().get((Object)"multipart/form-data") != null) {
            mediaType = "multipart/form-data";
        }
        return new FormProcessor(paramName, parameter, mediaType, targetType);
    }

    private boolean isPart(RequestBody parameter, String paramName) {
        MediaType file = (MediaType)parameter.getContent().get((Object)"multipart/form-data");
        if (file != null) {
            Schema schema = (Schema)file.getSchema().getProperties().get(paramName);
            if (schema instanceof ArraySchema) {
                return "string".equals(schema.getItems().getType()) && "binary".equals(schema.getItems().getFormat());
            }
            return "string".equals(schema.getType()) && "binary".equals(schema.getFormat());
        }
        return false;
    }

    public static class PartProcessor
    extends AbstractParamProcessor {
        private static final Type partListType = Types.newParameterizedType(List.class, (Type[])new Type[]{Part.class});
        private static final Map<Type, Converter> partsToTargetConverters = SPIServiceUtils.getSortedService(Converter.class).stream().filter(c -> partListType.equals(c.getSrcType())).collect(Collectors.toMap(Converter::getTargetType, Function.identity()));
        private static final Map<Type, Converter> partToTargetConverters = SPIServiceUtils.getSortedService(Converter.class).stream().filter(c -> c.getSrcType() instanceof Class && Part.class.isAssignableFrom((Class)c.getSrcType())).collect(Collectors.toMap(Converter::getTargetType, Function.identity()));
        private final boolean repeatedType;
        private Converter converter;

        PartProcessor(String paramName, RequestBody formParameter, Type genericParamType) {
            super(paramName, null, ((MediaType)formParameter.getContent().get((Object)"multipart/form-data")).getSchema().getDefault(), formParameter.getRequired() != null && formParameter.getRequired() != false);
            this.repeatedType = ((MediaType)formParameter.getContent().get((Object)"multipart/form-data")).getSchema().getProperties().get(paramName) instanceof ArraySchema;
            this.initConverter(genericParamType);
        }

        private void initConverter(Type genericParamType) {
            if (this.repeatedType) {
                this.initRepeatedConverter(genericParamType);
                return;
            }
            this.initNormalConverter(genericParamType);
        }

        private void initNormalConverter(Type genericParamType) {
            if (genericParamType instanceof JavaType) {
                genericParamType = ((JavaType)genericParamType).getRawClass();
            }
            this.converter = partToTargetConverters.get(genericParamType);
        }

        private void initRepeatedConverter(Type genericParamType) {
            if (genericParamType instanceof JavaType) {
                genericParamType = Types.newParameterizedType((Type)((JavaType)genericParamType).getRawClass(), (Type[])new Type[]{((JavaType)genericParamType).getContentType()});
            }
            this.converter = partsToTargetConverters.get(genericParamType);
        }

        @Override
        public Object getValue(HttpServletRequest request) throws Exception {
            if (this.repeatedType) {
                List parts = request.getParts().stream().filter(part -> part.getName().equals(this.paramPath)).collect(Collectors.toList());
                return this.convertValue(this.converter, parts);
            }
            return this.convertValue(this.converter, request.getPart(this.paramPath));
        }

        public Object convertValue(Converter converter, Object value) {
            if (value == null || converter == null) {
                return value;
            }
            return converter.convert(value);
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            clientRequest.attach(this.paramPath, arg);
        }

        @Override
        public String getProcessorType() {
            return FormProcessorCreator.PARAMTYPE;
        }
    }

    public static class FormProcessor
    extends AbstractParamProcessor {
        private final boolean repeatedType;

        public FormProcessor(String paraName, RequestBody formParameter, String mediaType, JavaType targetType) {
            super(paraName, targetType, ((MediaType)formParameter.getContent().get((Object)mediaType)).getSchema().getDefault(), formParameter.getRequired() != null && formParameter.getRequired() != false);
            this.repeatedType = ((MediaType)formParameter.getContent().get((Object)mediaType)).getSchema().getProperties().get(paraName) instanceof ArraySchema;
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            Map forms = (Map)request.getAttribute("servicecomb-body");
            if (forms != null && !forms.isEmpty()) {
                return this.convertValue(forms.get(this.paramPath), this.targetType);
            }
            if (this.repeatedType) {
                return this.convertValue(request.getParameterValues(this.paramPath), this.targetType);
            }
            Object value = request.getParameter(this.paramPath);
            if (value == null) {
                value = this.checkRequiredAndDefaultValue();
            }
            return this.convertValue(value, this.targetType);
        }

        private Object checkRequiredAndDefaultValue() {
            if (this.isRequired()) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Parameter is required.");
            }
            return this.getDefaultValue();
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) {
            clientRequest.addForm(this.paramPath, arg);
        }

        @Override
        public String getProcessorType() {
            return FormProcessorCreator.PARAMTYPE;
        }
    }
}

