/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.servicestage;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.servicecomb.foundation.auth.Cipher;
import org.apache.servicecomb.foundation.auth.DefaultCipher;
import org.apache.servicecomb.foundation.bootstrap.BootStrapService;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.http.client.auth.DefaultRequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportFactory;
import org.apache.servicecomb.huaweicloud.servicestage.TokenCacheManager;
import org.apache.servicecomb.service.center.client.ServiceCenterAddressManager;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.ServiceCenterRawClient;
import org.springframework.core.env.Environment;

public class RBACBootStrapService
implements BootStrapService {
    private static final String RBAC_ADDRESS = "servicecomb.service.registry.address";
    public static final String DEFAULT_REGISTRY_NAME = "default";
    public static final String RBAC_ENABLED = "servicecomb.credentials.rbac.enabled";
    public static final String ACCOUNT_NAME_KEY = "servicecomb.credentials.account.name";
    public static final String PASSWORD_KEY = "servicecomb.credentials.account.password";
    public static final String CIPHER_KEY = "servicecomb.credentials.cipher";
    public static final String PROJECT_KEY = "servicecomb.credentials.project";
    private static final String SSL_TAG = "sc.consumer";

    public void startup(Environment environment) {
        if (!this.getBooleanProperty(environment, false, RBAC_ENABLED)) {
            return;
        }
        ServiceCenterAddressManager addressManager = this.createAddressManager(environment);
        HttpConfiguration.SSLProperties sslProperties = this.createSSLProperties(environment);
        sslProperties.setEnabled(addressManager.sslEnabled());
        ServiceCenterClient serviceCenterClient = new ServiceCenterClient(new ServiceCenterRawClient.Builder().setTenantName(DEFAULT_REGISTRY_NAME).setAddressManager(addressManager).setHttpTransport(RBACBootStrapService.createHttpTransport(environment, sslProperties)).build());
        HashMap<String, ServiceCenterClient> clients = new HashMap<String, ServiceCenterClient>(1);
        clients.put(DEFAULT_REGISTRY_NAME, serviceCenterClient);
        TokenCacheManager.getInstance().setServiceCenterClients(clients);
        TokenCacheManager.getInstance().addTokenCache(DEFAULT_REGISTRY_NAME, this.getStringProperty(environment, null, ACCOUNT_NAME_KEY), this.getStringProperty(environment, null, PASSWORD_KEY), this.getCipher(this.getStringProperty(environment, DEFAULT_REGISTRY_NAME, CIPHER_KEY)));
    }

    private static HttpTransport createHttpTransport(Environment environment, HttpConfiguration.SSLProperties sslProperties) {
        if (RBACBootStrapService.isProxyEnable(environment).booleanValue()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(HttpTransportFactory.defaultRequestConfig().build());
            HttpHost proxy = new HttpHost(RBACBootStrapService.getProxyHost(environment), RBACBootStrapService.getProxyPort(environment), "http");
            httpClientBuilder.setProxy(proxy);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(RBACBootStrapService.getProxyUsername(environment), RBACBootStrapService.getProxyPasswd(environment)));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)sslProperties, (RequestAuthHeaderProvider)new DefaultRequestAuthHeaderProvider(), (HttpClientBuilder)httpClientBuilder);
        }
        return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)sslProperties, (RequestAuthHeaderProvider)new DefaultRequestAuthHeaderProvider(), (RequestConfig)HttpTransportFactory.defaultRequestConfig().build());
    }

    @VisibleForTesting
    Cipher getCipher(String cipherName) {
        if (DEFAULT_REGISTRY_NAME.equals(cipherName)) {
            return DefaultCipher.getInstance();
        }
        List ciphers = SPIServiceUtils.getOrLoadSortedService(Cipher.class);
        return ciphers.stream().filter(c -> c.name().equals(cipherName)).findFirst().orElseThrow(() -> new IllegalArgumentException("failed to find cipher named " + cipherName));
    }

    private ServiceCenterAddressManager createAddressManager(Environment environment) {
        return new ServiceCenterAddressManager(this.getProjectName(environment), this.getRBACAddressList(environment), EventManager.getEventBus());
    }

    private HttpConfiguration.SSLProperties createSSLProperties(Environment environment) {
        HttpConfiguration.SSLProperties sslProperties = new HttpConfiguration.SSLProperties();
        SSLOption option = new SSLOption();
        option.setEngine(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getEngine(), "ssl.sc.consumer.engine", "ssl.engine"));
        option.setProtocols(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getProtocols(), "ssl.sc.consumer.protocols", "ssl.protocols"));
        option.setCiphers(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getCiphers(), "ssl.sc.consumer.ciphers", "ssl.ciphers"));
        option.setAuthPeer(this.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isAuthPeer(), "ssl.sc.consumer.authPeer", "ssl.authPeer"));
        option.setCheckCNHost(this.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isCheckCNHost(), "ssl.sc.consumer.checkCN.host", "ssl.checkCN.host"));
        option.setCheckCNWhite(this.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isCheckCNWhite(), "ssl.sc.consumer.checkCN.white", "ssl.checkCN.white"));
        option.setCheckCNWhiteFile(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getCiphers(), "ssl.sc.consumer.checkCN.white.file", "ssl.checkCN.white.file"));
        option.setAllowRenegociate(this.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isAllowRenegociate(), "ssl.sc.consumer.allowRenegociate", "ssl.allowRenegociate"));
        option.setStorePath(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getStorePath(), "ssl.sc.consumer.storePath", "ssl.storePath"));
        option.setClientAuth(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getClientAuth(), "ssl.sc.consumer.clientAuth", "ssl.clientAuth"));
        option.setTrustStore(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getTrustStore(), "ssl.sc.consumer.trustStore", "ssl.trustStore"));
        option.setTrustStoreType(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getTrustStoreType(), "ssl.sc.consumer.trustStoreType", "ssl.trustStoreType"));
        option.setTrustStoreValue(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getTrustStoreValue(), "ssl.sc.consumer.trustStoreValue", "ssl.trustStoreValue"));
        option.setKeyStore(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getKeyStore(), "ssl.sc.consumer.keyStore", "ssl.keyStore"));
        option.setKeyStoreType(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getKeyStoreType(), "ssl.sc.consumer.keyStoreType", "ssl.keyStoreType"));
        option.setKeyStoreValue(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getKeyStoreValue(), "ssl.sc.consumer.keyStoreValue", "ssl.keyStoreValue"));
        option.setCrl(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getCrl(), "ssl.sc.consumer.crl", "ssl.crl"));
        option.setSslCustomClass(this.getStringProperty(environment, null, "ssl.sc.consumer.sslCustomClass", "ssl.sslCustomClass"));
        sslProperties.setSslOption(option);
        sslProperties.setSslCustom(SSLCustom.createSSLCustom((String)option.getSslCustomClass()));
        return sslProperties;
    }

    private String getStringProperty(Environment environment, String defaultValue, String ... keys) {
        for (String key : keys) {
            if (environment.getProperty(key) == null) continue;
            return environment.getProperty(key);
        }
        return defaultValue;
    }

    private boolean getBooleanProperty(Environment environment, boolean defaultValue, String ... keys) {
        for (String key : keys) {
            if (environment.getProperty(key) == null) continue;
            return Boolean.parseBoolean(environment.getProperty(key));
        }
        return defaultValue;
    }

    private String getProjectName(Environment environment) {
        return this.getStringProperty(environment, DEFAULT_REGISTRY_NAME, PROJECT_KEY);
    }

    private List<String> getRBACAddressList(Environment environment) {
        String address = environment.getProperty(RBAC_ADDRESS, "http://127.0.0.1:30100)");
        return Arrays.asList(address.split(","));
    }

    public static Boolean isProxyEnable(Environment environment) {
        return (Boolean)environment.getProperty("servicecomb.proxy.enable", Boolean.TYPE, (Object)false);
    }

    public static String getProxyHost(Environment environment) {
        return environment.getProperty("servicecomb.proxy.host", "127.0.0.1");
    }

    public static int getProxyPort(Environment environment) {
        return (Integer)environment.getProperty("servicecomb.proxy.port", Integer.TYPE, (Object)8080);
    }

    public static String getProxyUsername(Environment environment) {
        return environment.getProperty("servicecomb.proxy.username");
    }

    public static String getProxyPasswd(Environment environment) {
        return environment.getProperty("servicecomb.proxy.passwd");
    }
}

