/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.transport.common.TransportConfigUtils;

public final class TransportClientConfig {
    private static final int DEFAULT_IDLE_TIME_OUT = 150;
    private static final int DEFAULT_KEEP_ALIVE_TIME_OUT = 60;

    private TransportClientConfig() {
    }

    public static int getThreadCount() {
        return TransportConfigUtils.readVerticleCount((String)"servicecomb.rest.client.verticle-count", (String)"servicecomb.rest.client.thread-count");
    }

    public static int getHttp2ConnectionMaxPoolSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.client.http2.maxPoolSize", (int)1);
    }

    public static int getHttp2MultiplexingLimit() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.client.http2.multiplexingLimit", (int)-1);
    }

    public static boolean getUseAlpn() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.client.http2.useAlpnEnabled", (boolean)true);
    }

    public static boolean isHttp2TransportClientEnabled() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.client.http2.enabled", (boolean)true);
    }

    public static int getConnectionMaxPoolSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.client.connection.maxPoolSize", (int)5);
    }

    public static int getHttp2ConnectionIdleTimeoutInSeconds() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.client.http2.connection.idleTimeoutInSeconds", (int)150);
    }

    public static int getConnectionIdleTimeoutInSeconds() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.client.connection.idleTimeoutInSeconds", (int)150);
    }

    public static boolean getConnectionKeepAlive() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.client.connection.keepAlive", (boolean)true);
    }

    public static int getConnectionKeepAliveTimeoutInSeconds() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.client.connection.keepAliveTimeoutInSeconds", (int)60);
    }

    public static int getHttp2ConnectionKeepAliveTimeoutInSeconds() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.client.http2.connection.keepAliveTimeoutInSeconds", (int)60);
    }

    public static boolean getConnectionCompression() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.client.connection.compression", (boolean)false);
    }

    public static int getMaxHeaderSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.client.maxHeaderSize", (int)8192);
    }

    public static int getMaxWaitQueueSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.client.maxWaitQueueSize", (int)-1);
    }

    public static boolean isHttpTransportClientEnabled() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.client.enabled", (boolean)true);
    }

    public static int getConnectionTimeoutInMillis() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.client.connection.timeoutInMillis", (int)60000);
    }
}

