/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.client.http;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.ProxyOptions;
import org.apache.servicecomb.foundation.common.encrypt.Encryptions;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;

public interface HttpClientOptionsSPI {
    public String clientName();

    public int getOrder();

    public boolean enabled();

    public String getConfigTag();

    public int getEventLoopPoolSize();

    public boolean useSharedVertx();

    public int getInstanceCount();

    public boolean isWorker();

    public String getWorkerPoolName();

    public int getWorkerPoolSize();

    public HttpVersion getHttpVersion();

    public int getConnectTimeoutInMillis();

    public int getIdleTimeoutInSeconds();

    public boolean isTryUseCompression();

    public int getMaxWaitQueueSize();

    public int getMaxPoolSize();

    public boolean isKeepAlive();

    public int getMaxHeaderSize();

    public int getKeepAliveTimeout();

    public int getHttp2MultiplexingLimit();

    public int getHttp2MaxPoolSize();

    public boolean isUseAlpn();

    public boolean isProxyEnable();

    public String getProxyHost();

    public int getProxyPort();

    public String getProxyUsername();

    public String getProxyPassword();

    public boolean isSsl();

    public static HttpClientOptions createHttpClientOptions(HttpClientOptionsSPI spi) {
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        httpClientOptions.setProtocolVersion(spi.getHttpVersion());
        httpClientOptions.setConnectTimeout(spi.getConnectTimeoutInMillis());
        httpClientOptions.setIdleTimeout(spi.getIdleTimeoutInSeconds());
        httpClientOptions.setReadIdleTimeout(spi.getIdleTimeoutInSeconds());
        httpClientOptions.setWriteIdleTimeout(spi.getIdleTimeoutInSeconds());
        httpClientOptions.setTryUseCompression(spi.isTryUseCompression());
        httpClientOptions.setMaxWaitQueueSize(spi.getMaxWaitQueueSize());
        httpClientOptions.setMaxPoolSize(spi.getMaxPoolSize());
        httpClientOptions.setKeepAlive(spi.isKeepAlive());
        httpClientOptions.setMaxHeaderSize(spi.getMaxHeaderSize());
        if (spi.isProxyEnable()) {
            ProxyOptions proxy = new ProxyOptions();
            proxy.setHost(spi.getProxyHost());
            proxy.setPort(spi.getProxyPort());
            proxy.setUsername(spi.getProxyUsername());
            proxy.setPassword(Encryptions.decode((String)spi.getProxyPassword(), (String)spi.getConfigTag()));
            httpClientOptions.setProxyOptions(proxy);
        }
        if (spi.getHttpVersion() == HttpVersion.HTTP_2) {
            httpClientOptions.setUseAlpn(spi.isUseAlpn());
            httpClientOptions.setHttp2ClearTextUpgrade(false);
            httpClientOptions.setHttp2MultiplexingLimit(spi.getHttp2MultiplexingLimit());
            httpClientOptions.setHttp2MaxPoolSize(spi.getHttp2MaxPoolSize());
            httpClientOptions.setHttp2KeepAliveTimeout(spi.getKeepAliveTimeout());
        } else {
            httpClientOptions.setKeepAliveTimeout(spi.getKeepAliveTimeout());
        }
        if (spi.isSsl()) {
            VertxTLSBuilder.buildHttpClientOptions(spi.getConfigTag(), httpClientOptions);
        }
        return httpClientOptions;
    }
}

