/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.invocation;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.meter.LatencyDistributionConfig;

public abstract class AbstractInvocationMeter {
    private final DistributionSummary totalSummary;
    private final Timer totalTimer;
    private final Timer prepareTimer;
    protected final MetricsBootstrapConfig metricsBootstrapConfig;

    public AbstractInvocationMeter(MeterRegistry meterRegistry, String name, Tags tags, MetricsBootstrapConfig metricsBootstrapConfig) {
        this.metricsBootstrapConfig = metricsBootstrapConfig;
        this.totalSummary = !StringUtils.isEmpty((CharSequence)metricsBootstrapConfig.getLatencyDistribution()) ? DistributionSummary.builder((String)name).tags((Iterable)tags.and("type", "distribution")).distributionStatisticExpiry(Duration.ofMillis(metricsBootstrapConfig.getMsPollInterval())).serviceLevelObjectives(AbstractInvocationMeter.toSla(metricsBootstrapConfig.getLatencyDistribution())).register(meterRegistry) : null;
        this.totalTimer = Timer.builder((String)name).tags((Iterable)tags.and(new String[]{"type", "stage", "stage", "total"})).register(meterRegistry);
        this.prepareTimer = Timer.builder((String)name).tags((Iterable)tags.and(new String[]{"type", "stage", "stage", "prepare"})).register(meterRegistry);
    }

    protected static double[] toSla(String config) {
        config = ((String)config).trim() + "," + LatencyDistributionConfig.MAX_LATENCY;
        String[] array = ((String)config).split("\\s*,+\\s*");
        double[] result = new double[array.length];
        for (int idx = 0; idx < array.length - 1; ++idx) {
            long msMax;
            long msMin = Long.parseLong(array[idx]);
            if (msMin >= (msMax = Long.parseLong(array[idx + 1]))) {
                String msg = String.format("invalid latency scope, min=%s, max=%s.", array[idx], array[idx + 1]);
                throw new IllegalStateException(msg);
            }
            result[idx] = msMin;
        }
        result[array.length - 1] = LatencyDistributionConfig.MAX_LATENCY.longValue();
        if (Double.compare(0.0, result[0]) == 0) {
            double[] target = new double[result.length - 1];
            System.arraycopy(result, 1, target, 0, target.length);
            return target;
        }
        return result;
    }

    public void onInvocationFinish(InvocationFinishEvent event) {
        InvocationStageTrace stageTrace = event.getInvocation().getInvocationStageTrace();
        this.totalTimer.record(stageTrace.calcTotal(), TimeUnit.NANOSECONDS);
        this.prepareTimer.record(stageTrace.calcPrepare(), TimeUnit.NANOSECONDS);
        if (this.totalSummary != null) {
            this.totalSummary.record((double)TimeUnit.NANOSECONDS.toMillis(stageTrace.calcTotal()));
        }
    }
}

