/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.validator;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.groups.Default;
import java.util.Set;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.extension.ProducerInvokeExtension;
import org.apache.servicecomb.swagger.invocation.validator.DefaultParameterNameProvider;
import org.hibernate.validator.messageinterpolation.AbstractMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterValidator
implements ProducerInvokeExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterValidator.class);
    private static final String PARAM_VALIDATION_ENABLED = "servicecomb.rest.parameter.validation.enabled";
    private static final String ENABLE_EL = "servicecomb.filters.validation.useResourceBundleMessageInterpolator";
    private final boolean paramValidationEnabled = LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.parameter.validation.enabled", (boolean)true);
    private static ExecutableValidator executableValidator;

    public void beforeMethodInvoke(SwaggerInvocation invocation, SwaggerProducerOperation producerOperation, Object[] args) throws ConstraintViolationException {
        if (this.paramValidationEnabled) {
            Set violations;
            if (null == executableValidator) {
                ValidatorFactory factory = Validation.byDefaultProvider().configure().parameterNameProvider((ParameterNameProvider)new DefaultParameterNameProvider()).messageInterpolator((MessageInterpolator)this.messageInterpolator()).buildValidatorFactory();
                executableValidator = factory.getValidator().forExecutables();
            }
            if ((violations = executableValidator.validateParameters(producerOperation.getProducerInstance(), producerOperation.getProducerMethod(), args, new Class[]{Default.class})).size() > 0) {
                LOGGER.warn("Parameter validation failed : " + violations);
                throw new ConstraintViolationException(violations);
            }
        }
    }

    private AbstractMessageInterpolator messageInterpolator() {
        if (this.useResourceBundleMessageInterpolator()) {
            return new ResourceBundleMessageInterpolator();
        }
        return new ParameterMessageInterpolator();
    }

    private boolean useResourceBundleMessageInterpolator() {
        return LegacyPropertyFactory.getBooleanProperty((String)ENABLE_EL, (boolean)false);
    }

    public int getOrder() {
        return 100;
    }
}

