/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.util.ParameterProcessor;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.ParameterGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;

public class ParameterGenerator {
    private final List<Annotation> annotations;
    private final OperationGenerator operationGenerator;
    private final ParameterGeneratorContext parameterGeneratorContext;

    public ParameterGenerator(OperationGenerator operationGenerator, String parameterName, Schema<?> schema) {
        this.operationGenerator = operationGenerator;
        this.parameterGeneratorContext = new ParameterGeneratorContext(operationGenerator.getOperationGeneratorContext());
        this.parameterGeneratorContext.setParameterName(parameterName);
        this.parameterGeneratorContext.setSchema(schema);
        this.annotations = Collections.emptyList();
    }

    public ParameterGenerator(OperationGenerator operationGenerator, Map<String, List<Annotation>> methodAnnotationMap, String parameterName, Annotation[] parameterAnnotations, JavaType genericType) {
        this.operationGenerator = operationGenerator;
        this.annotations = SwaggerGeneratorUtils.collectParameterAnnotations(parameterAnnotations, methodAnnotationMap, parameterName);
        this.parameterGeneratorContext = new ParameterGeneratorContext(operationGenerator.getOperationGeneratorContext());
        this.parameterGeneratorContext.setParameterName(parameterName);
        this.parameterGeneratorContext.setParameterType(genericType);
    }

    public ParameterGenerator(OperationGenerator operationGenerator, Map<String, List<Annotation>> methodAnnotationMap, java.lang.reflect.Parameter methodParameter, JavaType genericType) {
        this(operationGenerator, methodAnnotationMap, methodParameter.isNamePresent() ? methodParameter.getName() : null, methodParameter.getAnnotations(), genericType);
    }

    public ParameterGenerator(OperationGenerator operationGenerator, String parameterName, List<Annotation> annotations) {
        this.operationGenerator = operationGenerator;
        this.parameterGeneratorContext = new ParameterGeneratorContext(operationGenerator.getOperationGeneratorContext());
        this.parameterGeneratorContext.setParameterName(parameterName);
        this.annotations = annotations;
    }

    public ParameterGeneratorContext getParameterGeneratorContext() {
        return this.parameterGeneratorContext;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public JavaType getGenericType() {
        return this.parameterGeneratorContext.getParameterType();
    }

    public HttpParameterType getHttpParameterType() {
        return this.parameterGeneratorContext.getHttpParameterType();
    }

    public void setHttpParameterType(HttpParameterType httpParameterType) {
        this.parameterGeneratorContext.setHttpParameterType(httpParameterType);
    }

    public boolean isForm() {
        return this.parameterGeneratorContext.isForm();
    }

    public boolean isBinary() {
        return this.parameterGeneratorContext.isBinary();
    }

    public void generate() {
        this.parameterGeneratorContext.updateConsumes(this.operationGenerator.isForm(), this.operationGenerator.isBinary());
        if (this.parameterGeneratorContext.getHttpParameterType() == HttpParameterType.BODY) {
            if (this.parameterGeneratorContext.getSupportedConsumes().size() == 0) {
                throw new IllegalArgumentException("Consumes not provided for BODY parameter, or is empty by annotations rule.");
            }
            RequestBody requestBody = new RequestBody();
            requestBody.setRequired(this.parameterGeneratorContext.getRequired());
            HashMap<String, Object> extensions = new HashMap<String, Object>();
            extensions.put("x-name", this.parameterGeneratorContext.getParameterName());
            if (this.parameterGeneratorContext.getRawJson() != null) {
                extensions.put("x-raw-json", this.parameterGeneratorContext.getRawJson());
            }
            requestBody.setExtensions(extensions);
            requestBody.setContent(new Content());
            for (String media : this.parameterGeneratorContext.getSupportedConsumes()) {
                MediaType mediaType = new MediaType();
                mediaType.setSchema(this.parameterGeneratorContext.getSchema());
                requestBody.getContent().addMediaType(media, mediaType);
            }
            this.operationGenerator.getOperation().setRequestBody(requestBody);
            return;
        }
        if (this.parameterGeneratorContext.getHttpParameterType() == HttpParameterType.FORM) {
            if (this.parameterGeneratorContext.getSupportedConsumes().size() == 0) {
                throw new IllegalArgumentException("Consumes not provided for FORM parameter, or is empty by annotations rule.");
            }
            RequestBody requestBody = this.operationGenerator.getOperation().getRequestBody();
            if (requestBody == null) {
                requestBody = new RequestBody();
                requestBody.setContent(new Content());
                this.operationGenerator.getOperation().setRequestBody(requestBody);
            }
            for (String media : this.parameterGeneratorContext.getSupportedConsumes()) {
                MediaType mediaType = (MediaType)requestBody.getContent().get((Object)media);
                if (mediaType == null) {
                    mediaType = new MediaType();
                    mediaType.setSchema((Schema)new ObjectSchema());
                    requestBody.getContent().addMediaType(media, mediaType);
                }
                mediaType.getSchema().addProperty(this.parameterGeneratorContext.getParameterName(), this.parameterGeneratorContext.getSchema());
            }
            return;
        }
        PathParameter parameter = switch (this.parameterGeneratorContext.getHttpParameterType()) {
            case HttpParameterType.PATH -> new PathParameter();
            case HttpParameterType.QUERY -> new QueryParameter();
            case HttpParameterType.HEADER -> new HeaderParameter();
            case HttpParameterType.COOKIE -> new CookieParameter();
            default -> throw new IllegalStateException("not support httpParameterType " + this.parameterGeneratorContext.getHttpParameterType());
        };
        parameter.setName(this.parameterGeneratorContext.getParameterName());
        parameter.setSchema(this.parameterGeneratorContext.getSchema());
        parameter.setRequired(this.parameterGeneratorContext.getRequired());
        parameter.setExplode(this.parameterGeneratorContext.getExplode());
        this.operationGenerator.getOperation().addParametersItem((Parameter)parameter);
        if (this.parameterGeneratorContext.getParameterType() != null) {
            ParameterProcessor.applyAnnotations((Parameter)parameter, (Type)this.parameterGeneratorContext.getParameterType(), this.annotations, (Components)this.operationGenerator.getSwagger().getComponents(), null, null, null);
        }
        if (this.parameterGeneratorContext.getDefaultValue() != null) {
            parameter.getSchema().setDefault(this.parameterGeneratorContext.getDefaultValue());
        }
    }
}

