/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.servicecomb.common.rest.codec.query.QueryCodec;
import org.apache.servicecomb.common.rest.definition.path.URLPathBuilder;

public abstract class AbstractQueryCodec
implements QueryCodec {
    private final String codecName;

    public AbstractQueryCodec(String codecName) {
        this.codecName = codecName;
    }

    @Override
    public String getCodecName() {
        return this.codecName;
    }

    @Override
    public void encode(URLPathBuilder.URLPathStringBuilder builder, String name, Object value) throws Exception {
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            this.encode(builder, name, Arrays.asList((Object[])value));
            return;
        }
        if (value instanceof Collection) {
            this.encode(builder, name, (Collection)value);
            return;
        }
        this.encode(builder, name, Collections.singletonList(value));
    }

    abstract void encode(URLPathBuilder.URLPathStringBuilder var1, String var2, Collection<Object> var3) throws Exception;
}

