/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.netflix.config.DynamicPropertyFactory;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.BufferImpl;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.converter.ConverterMgr;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyProcessorCreator
implements ParamValueProcessorCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BodyProcessorCreator.class);
    public static final String PARAM_TYPE = "body";
    private static final JavaType OBJECT_TYPE = SimpleType.constructUnsafe(Object.class);
    private static final boolean decodeAsObject = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.decodeAsObject", false).get();

    public BodyProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAM_TYPE, this);
    }

    @Override
    public ParamValueProcessor create(Parameter parameter, Type genericParamType) {
        Model model = ((BodyParameter)parameter).getSchema();
        JavaType swaggerType = null;
        if (model instanceof ModelImpl) {
            swaggerType = ConverterMgr.findJavaType((String)((ModelImpl)model).getType(), (String)((ModelImpl)model).getFormat());
        }
        boolean isString = swaggerType != null && swaggerType.getRawClass().equals(String.class);
        JavaType targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        boolean rawJson = SwaggerUtils.isRawJsonType((Parameter)parameter);
        if (rawJson) {
            return new RawJsonBodyProcessor(targetType, (String)parameter.getVendorExtensions().get("x-json-view"), isString, parameter.getRequired());
        }
        return new BodyProcessor(targetType, (String)parameter.getVendorExtensions().get("x-json-view"), isString, parameter.getRequired());
    }

    public static class RawJsonBodyProcessor
    extends BodyProcessor {
        public RawJsonBodyProcessor(JavaType targetType, boolean isString, boolean isRequired) {
            this(targetType, null, isString, isRequired);
        }

        public RawJsonBodyProcessor(JavaType targetType, String serialViewClass, boolean isString, boolean isRequired) {
            super(targetType, serialViewClass, isString, isRequired);
        }

        @Override
        public Object getValue(HttpServletRequest request) throws Exception {
            Object body = request.getAttribute("servicecomb-body");
            if (body != null) {
                return this.convertValue(body, this.targetType);
            }
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream == null) {
                return null;
            }
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            if (arg instanceof String) {
                clientRequest.putHeader("Content-Type", "application/json");
                clientRequest.write(Buffer.buffer((String)((String)arg)));
                return;
            }
            super.setValue(clientRequest, arg);
        }
    }

    public static class BodyProcessor
    implements ParamValueProcessor {
        protected JavaType targetType;
        protected Class<?> serialViewClass;
        private final boolean isString;
        protected boolean isRequired;

        public BodyProcessor(JavaType targetType, boolean isString, boolean isRequired) {
            this(targetType, null, isString, isRequired);
        }

        public BodyProcessor(JavaType targetType, String serialViewClass, boolean isString, boolean isRequired) {
            if (!StringUtils.isEmpty((CharSequence)serialViewClass)) {
                try {
                    this.serialViewClass = Class.forName(serialViewClass);
                }
                catch (Throwable e) {
                    LOGGER.warn("Failed to create body processor {}, annotation @JsonView may be invalid", (Object)serialViewClass, (Object)e);
                }
            }
            this.targetType = targetType;
            this.isString = isString;
            this.isRequired = isRequired;
        }

        @Override
        public Class<?> getSerialViewClass() {
            return this.serialViewClass;
        }

        @Override
        public Object getValue(HttpServletRequest request) throws Exception {
            Object result = this.getValueImpl(request);
            if (result == null && this.isRequired) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Body parameter is required.");
            }
            return result;
        }

        private Object getValueImpl(HttpServletRequest request) throws IOException {
            Object body = request.getAttribute("servicecomb-body");
            if (body != null) {
                return this.convertValue(body, this.targetType);
            }
            String contentType = request.getContentType();
            String string = contentType = contentType == null ? "" : contentType.toLowerCase(Locale.US);
            if (contentType.startsWith("multipart/form-data") || contentType.startsWith("application/x-www-form-urlencoded")) {
                return this.convertValue(request.getParameterMap(), this.targetType);
            }
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream == null) {
                return null;
            }
            if (!contentType.isEmpty() && !contentType.startsWith("application/json")) {
                return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
            try {
                ObjectReader reader;
                ObjectReader objectReader = reader = this.serialViewClass != null ? RestObjectMapperFactory.getRestObjectMapper().readerWithView(this.serialViewClass) : RestObjectMapperFactory.getRestObjectMapper().reader();
                if (decodeAsObject) {
                    return reader.forType(OBJECT_TYPE).readValue((InputStream)inputStream);
                }
                return reader.forType(this.targetType == null ? OBJECT_TYPE : this.targetType).readValue((InputStream)inputStream);
            }
            catch (MismatchedInputException e) {
                if (!this.isRequired && e.getMessage().contains("No content to map due to end-of-input")) {
                    LOGGER.info("Empty content and required is false, taken as null");
                    return null;
                }
                throw e;
            }
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            this.ensureContentType(clientRequest);
            if (arg != null) {
                Buffer buffer = this.createBodyBuffer(clientRequest.getHeaders().get("Content-Type"), arg);
                clientRequest.write(buffer);
            }
        }

        private Buffer createBodyBuffer(String contentType, Object arg) throws IOException {
            if ("text/plain".equals(contentType)) {
                if (!(arg instanceof String)) {
                    throw new IllegalArgumentException("Content-Type is text/plain while arg type is not String");
                }
                return new BufferImpl().appendBytes(((String)arg).getBytes(StandardCharsets.UTF_8));
            }
            try (BufferOutputStream output = new BufferOutputStream();){
                RestObjectMapperFactory.getConsumerWriterMapper().writeValue((OutputStream)output, arg);
                Buffer buffer = output.getBuffer();
                return buffer;
            }
        }

        private void ensureContentType(RestClientRequest clientRequest) {
            if (null == clientRequest.getHeaders() || StringUtils.isEmpty((CharSequence)clientRequest.getHeaders().get("Content-Type"))) {
                clientRequest.putHeader("Content-Type", "application/json");
            }
        }

        @Override
        public String getParameterPath() {
            return "";
        }

        @Override
        public String getProcessorType() {
            return BodyProcessorCreator.PARAM_TYPE;
        }
    }
}

