/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter.inner;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.MultiMap;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.HttpTransportContext;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProducerFilter;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.swagger.invocation.Response;
import org.springframework.stereotype.Component;

@Component
public class RestServerCodecFilter
implements ProducerFilter {
    public static final String NAME = "rest-server-codec";

    @Nonnull
    public String getName() {
        return NAME;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(invocation).thenAccept(this::decodeRequest)).thenCompose(v -> this.invokeNext(invocation, nextNode))).exceptionally(exception -> Exceptions.toProducerResponse((Invocation)invocation, (Throwable)exception))).thenCompose(response -> this.encodeResponse(invocation, (Response)response));
    }

    protected CompletableFuture<Response> invokeNext(Invocation invocation, FilterNode nextNode) {
        return nextNode.onFilter(invocation);
    }

    protected Void decodeRequest(Invocation invocation) {
        HttpServletRequestEx requestEx = invocation.getRequestEx();
        OperationMeta operationMeta = invocation.getOperationMeta();
        RestOperationMeta restOperationMeta = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        Map<String, Object> swaggerArguments = RestCodec.restToArgs((HttpServletRequest)requestEx, restOperationMeta);
        invocation.setSwaggerArguments(swaggerArguments);
        return null;
    }

    protected CompletableFuture<Response> encodeResponse(Invocation invocation, Response response) {
        invocation.onEncodeResponseStart(response);
        HttpTransportContext transportContext = (HttpTransportContext)invocation.getTransportContext();
        ProduceProcessor produceProcessor = transportContext.getProduceProcessor();
        HttpServletResponseEx responseEx = transportContext.getResponseEx();
        boolean download = RestServerCodecFilter.isDownloadFileResponseType(invocation, response);
        return RestServerCodecFilter.encodeResponse(response, download, produceProcessor, responseEx);
    }

    public static CompletableFuture<Response> encodeResponse(Response response, boolean download, ProduceProcessor produceProcessor, HttpServletResponseEx responseEx) {
        CompletableFuture<Response> completableFuture;
        responseEx.setStatus(response.getStatusCode());
        RestServerCodecFilter.copyHeadersToHttpResponse(response.getHeaders(), responseEx);
        if (download) {
            return CompletableFuture.completedFuture(response);
        }
        responseEx.setContentType(produceProcessor.getName() + "; charset=utf-8");
        BufferOutputStream output = new BufferOutputStream((ByteBuf)Unpooled.compositeBuffer());
        try {
            produceProcessor.encodeResponse((OutputStream)output, response.getResult());
            responseEx.setBodyBuffer(output.getBuffer());
            completableFuture = CompletableFuture.completedFuture(response);
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                return AsyncUtils.completeExceptionally((Throwable)e);
            }
        }
        output.close();
        return completableFuture;
    }

    public static boolean isDownloadFileResponseType(Invocation invocation, Response response) {
        return Part.class.isAssignableFrom(invocation.findResponseType(response.getStatusCode()).getRawClass());
    }

    public static void copyHeadersToHttpResponse(MultiMap headers, HttpServletResponseEx responseEx) {
        if (headers == null) {
            return;
        }
        headers.remove("Content-Length");
        headers.remove("Transfer-Encoding");
        for (Map.Entry entry : headers.entries()) {
            responseEx.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

