/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.DynamicPropertyFactory;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessorManager;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.common.rest.filter.HttpServerFilterBeforeSendResponseExecutor;
import org.apache.servicecomb.common.rest.filter.inner.RestServerCodecFilter;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.config.YAMLUtil;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.Holder;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.swagger.invocation.ws.ServerWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestInvocation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRestInvocation.class);
    public static final String UNKNOWN_OPERATION_ID = "UNKNOWN_OPERATION";
    private final Map<String, Object> headerContextMappers;
    private final Map<String, Object> queryContextMappers;
    protected long start;
    protected RestOperationMeta restOperationMeta;
    protected Invocation invocation;
    protected HttpServletRequestEx requestEx;
    protected HttpServletResponseEx responseEx;
    protected ProduceProcessor produceProcessor;
    protected List<HttpServerFilter> httpServerFilters = Collections.emptyList();

    public AbstractRestInvocation() {
        this.start = System.nanoTime();
        String headerContextMapper = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.context.headerContextMapper", null).get();
        String queryContextMapper = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.context.queryContextMapper", null).get();
        this.headerContextMappers = headerContextMapper != null ? YAMLUtil.yaml2Properties((String)headerContextMapper) : new HashMap<String, Object>();
        this.queryContextMappers = queryContextMapper != null ? YAMLUtil.yaml2Properties((String)queryContextMapper) : new HashMap<String, Object>();
    }

    public void setHttpServerFilters(List<HttpServerFilter> httpServerFilters) {
        this.httpServerFilters = httpServerFilters;
    }

    protected void findRestOperation(MicroserviceMeta microserviceMeta) {
        ServicePathManager servicePathManager = ServicePathManager.getServicePathManager(microserviceMeta);
        if (servicePathManager == null) {
            LOGGER.error("No schema defined for {}:{}.", (Object)microserviceMeta.getAppId(), (Object)microserviceMeta.getMicroserviceName());
            throw new InvocationException((Response.StatusType)Response.Status.NOT_FOUND, Response.Status.NOT_FOUND.getReasonPhrase());
        }
        OperationLocator locator = this.locateOperation(servicePathManager);
        this.requestEx.setAttribute("servicecomb-paths", locator.getPathVarMap());
        this.restOperationMeta = locator.getOperation();
    }

    protected void initProduceProcessor() {
        this.produceProcessor = this.restOperationMeta.ensureFindProduceProcessor(this.requestEx);
        if (this.produceProcessor == null) {
            LOGGER.error("Accept {} is not supported, operation={}.", (Object)this.requestEx.getHeader("Accept"), (Object)this.restOperationMeta.getOperationMeta().getMicroserviceQualifiedName());
            String msg = String.format("Accept %s is not supported", this.requestEx.getHeader("Accept"));
            throw new InvocationException((Response.StatusType)Response.Status.NOT_ACCEPTABLE, msg);
        }
    }

    @VisibleForTesting
    public void setContext() throws Exception {
        String strCseContext = this.requestEx.getHeader("x-cse-context");
        if (StringUtils.isEmpty((CharSequence)strCseContext)) {
            return;
        }
        Map cseContext = (Map)JsonUtils.readValue((byte[])strCseContext.getBytes(StandardCharsets.UTF_8), Map.class);
        this.invocation.mergeContext(cseContext);
        this.addParameterContext();
    }

    protected void addParameterContext() {
        this.headerContextMappers.forEach((k, v) -> {
            if (v instanceof String && this.requestEx.getHeader(k) != null) {
                this.invocation.addContext((String)v, this.requestEx.getHeader(k));
            }
        });
        this.queryContextMappers.forEach((k, v) -> {
            if (v instanceof String && this.requestEx.getParameter(k) != null) {
                this.invocation.addContext((String)v, this.requestEx.getParameter(k));
            }
        });
    }

    public String getContext(String key) {
        if (null == this.invocation || null == this.invocation.getContext()) {
            return null;
        }
        return this.invocation.getContext(key);
    }

    protected void scheduleInvocation() {
        try {
            this.createInvocation();
        }
        catch (Throwable e) {
            this.sendFailResponse(e);
            return;
        }
        try {
            this.setContext();
        }
        catch (Exception e) {
            LOGGER.error("failed to set invocation context", (Throwable)e);
            this.sendFailResponse(e);
            return;
        }
        this.invocation.onStart(this.requestEx, this.start);
        this.invocation.getInvocationStageTrace().startSchedule();
        OperationMeta operationMeta = this.restOperationMeta.getOperationMeta();
        Holder<Boolean> qpsFlowControlReject = this.checkQpsFlowControl(operationMeta);
        if (((Boolean)qpsFlowControlReject.value).booleanValue()) {
            return;
        }
        try {
            operationMeta.getExecutor().execute(() -> {
                HttpServletRequestEx httpServletRequestEx = this.requestEx;
                synchronized (httpServletRequestEx) {
                    try {
                        if (this.isInQueueTimeout()) {
                            this.invocation.onExecuteStart();
                            throw new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Timeout when processing the request.");
                        }
                        if (this.requestEx.getAttribute("servicecomb-rest-request") != this.requestEx) {
                            LOGGER.error("Rest request already timeout, abandon execute, method {}, operation {}.", (Object)operationMeta.getHttpMethod(), (Object)operationMeta.getMicroserviceQualifiedName());
                            return;
                        }
                        this.runOnExecutor();
                    }
                    catch (InvocationException e) {
                        LOGGER.error("Invocation failed, cause={}", (Object)e.getMessage());
                        this.sendFailResponse(e);
                    }
                    catch (Throwable e) {
                        LOGGER.error("Processing rest server request error", e);
                        this.sendFailResponse(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            LOGGER.error("failed to schedule invocation, message={}, executor={}.", (Object)e.getMessage(), (Object)e.getClass().getName());
            this.sendFailResponse(e);
        }
    }

    private Holder<Boolean> checkQpsFlowControl(OperationMeta operationMeta) {
        Holder qpsFlowControlReject = new Holder((Object)false);
        Handler providerQpsFlowControlHandler = operationMeta.getProviderQpsFlowControlHandler();
        if (null != providerQpsFlowControlHandler) {
            try {
                providerQpsFlowControlHandler.handle(this.invocation, response -> {
                    qpsFlowControlReject.value = true;
                    this.produceProcessor = ProduceProcessorManager.INSTANCE.findDefaultJsonProcessor();
                    this.sendResponse(response);
                });
            }
            catch (Throwable e) {
                LOGGER.error("failed to execute ProviderQpsFlowControlHandler", e);
                qpsFlowControlReject.value = true;
                this.sendFailResponse(e);
            }
        }
        return qpsFlowControlReject;
    }

    private boolean isInQueueTimeout() {
        return System.nanoTime() - this.invocation.getInvocationStageTrace().getStart() > this.invocation.getOperationMeta().getConfig().getNanoRestRequestWaitInPoolTimeout();
    }

    protected void runOnExecutor() {
        this.invocation.onExecuteStart();
        this.invoke();
    }

    protected abstract OperationLocator locateOperation(ServicePathManager var1);

    protected abstract void createInvocation();

    public void invoke() {
        try {
            Response response = this.prepareInvoke();
            if (response != null) {
                this.sendResponseQuietly(response);
                return;
            }
            this.doInvoke();
        }
        catch (InvocationException e) {
            LOGGER.error("Invocation failed, cause={}", (Object)e.getMessage());
            this.sendFailResponse(e);
        }
        catch (Throwable e) {
            LOGGER.error("Processing rest server request error", e);
            this.sendFailResponse(e);
        }
    }

    protected Response prepareInvoke() throws Throwable {
        this.initProduceProcessor();
        this.invocation.getHandlerContext().put("servicecomb-rest-request", this.requestEx);
        this.invocation.getInvocationStageTrace().startServerFiltersRequest();
        for (HttpServerFilter filter : this.httpServerFilters) {
            Response response;
            if (!filter.enabled() || !filter.enabledForTransport(this.invocation.getProviderTransportName()) || (response = filter.afterReceiveRequest(this.invocation, this.requestEx)) == null) continue;
            return response;
        }
        return null;
    }

    protected void doInvoke() throws Throwable {
        this.invocation.onStartHandlersRequest();
        this.invocation.next(this::sendResponseQuietly);
    }

    public void sendFailResponse(Throwable throwable) {
        if (this.produceProcessor == null) {
            this.produceProcessor = ProduceProcessorManager.INSTANCE.findDefaultProcessor();
        }
        Response response = Response.createProducerFail((Throwable)throwable);
        this.sendResponseQuietly(response);
    }

    protected void sendResponseQuietly(Response response) {
        if (this.invocation != null) {
            this.invocation.getInvocationStageTrace().finishHandlersResponse();
        }
        try {
            this.sendResponse(response);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to send rest response, operation:{}, request uri:{}", new Object[]{this.getMicroserviceQualifiedName(), this.requestEx.getRequestURI(), e});
        }
    }

    protected void sendResponse(Response response) {
        RestServerCodecFilter.copyHeadersToHttpResponse(response.getHeaders(), this.responseEx);
        if (!(response.getResult() instanceof ServerWebSocket)) {
            this.responseEx.setStatus(response.getStatusCode());
        }
        this.responseEx.setAttribute("servicecomb-invocation-hanlder-response", (Object)response);
        this.responseEx.setAttribute("servicecomb-invocation-hanlder-processor", (Object)this.produceProcessor);
        this.executeHttpServerFilters(response);
    }

    protected void executeHttpServerFilters(Response response) {
        HttpServerFilterBeforeSendResponseExecutor exec = new HttpServerFilterBeforeSendResponseExecutor(this.httpServerFilters, this.invocation, this.responseEx);
        CompletableFuture<Void> future = exec.run();
        future.whenComplete((v, e) -> {
            if (this.invocation != null) {
                this.invocation.getInvocationStageTrace().finishServerFiltersResponse();
            }
            this.onExecuteHttpServerFiltersFinish(response, (Throwable)e);
        });
    }

    protected void onExecuteHttpServerFiltersFinish(Response response, Throwable e) {
        if (e != null) {
            LOGGER.error("Failed to execute HttpServerFilters, operation:{}, request uri:{}", new Object[]{this.getMicroserviceQualifiedName(), this.requestEx.getRequestURI(), e});
        }
        if (!(response.getResult() instanceof ServerWebSocket)) {
            try {
                this.responseEx.flushBuffer();
            }
            catch (Throwable flushException) {
                LOGGER.error("Failed to flush rest response, operation:{}, request uri:{}", new Object[]{this.getMicroserviceQualifiedName(), this.requestEx.getRequestURI(), flushException});
            }
            try {
                this.requestEx.getAsyncContext().complete();
            }
            catch (Throwable completeException) {
                LOGGER.error("Failed to complete async rest response, operation:{}, request uri:{}", new Object[]{this.getMicroserviceQualifiedName(), this.requestEx.getRequestURI(), completeException});
            }
        }
        if (this.invocation != null) {
            this.invocation.onFinish(response);
        }
    }

    private String getMicroserviceQualifiedName() {
        return null == this.invocation ? UNKNOWN_OPERATION_ID : this.invocation.getMicroserviceQualifiedName();
    }
}

