/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.streams.WriteStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Part;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.foundation.common.utils.PartUtils;
import org.apache.servicecomb.foundation.vertx.stream.BufferInputStream;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.foundation.vertx.stream.InputStreamToReadStream;
import org.apache.servicecomb.foundation.vertx.stream.PumpFromPart;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientRequestImpl
implements RestClientRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClientRequestImpl.class);
    protected Context context;
    protected AsyncResponse asyncResp;
    @VisibleForTesting
    final Multimap<String, Part> uploads = ArrayListMultimap.create();
    protected HttpClientRequest request;
    protected Map<String, String> cookieMap;
    protected Map<String, Object> formMap;
    protected Buffer bodyBuffer;
    private final Handler<Throwable> throwableHandler;

    public RestClientRequestImpl(HttpClientRequest request, Context context, AsyncResponse asyncResp) {
        this(request, context, asyncResp, null);
    }

    public RestClientRequestImpl(HttpClientRequest request, Context context, AsyncResponse asyncResp, Handler<Throwable> throwableHandler) {
        this.context = context;
        this.asyncResp = asyncResp;
        this.request = request;
        this.throwableHandler = throwableHandler;
    }

    @Override
    public void write(Buffer bodyBuffer) {
        this.bodyBuffer = bodyBuffer;
    }

    @Override
    public Buffer getBodyBuffer() throws Exception {
        this.genBodyBuffer();
        return this.bodyBuffer;
    }

    @Override
    public void attach(String name, Object partOrList) {
        if (null == partOrList) {
            LOGGER.debug("null file is ignored, file name = [{}]", (Object)name);
            return;
        }
        if (partOrList.getClass().isArray()) {
            for (Object part : (Object[])partOrList) {
                this.uploads.put((Object)name, (Object)PartUtils.getSinglePart((String)name, (Object)part));
            }
        }
        if (List.class.isAssignableFrom(partOrList.getClass())) {
            for (Object part : (List)partOrList) {
                this.uploads.put((Object)name, (Object)PartUtils.getSinglePart((String)name, part));
            }
            return;
        }
        this.uploads.put((Object)name, (Object)PartUtils.getSinglePart((String)name, (Object)partOrList));
    }

    @Override
    public Future<Void> end() {
        this.writeCookies();
        if (!this.uploads.isEmpty()) {
            return this.doEndWithUpload();
        }
        return this.doEndNormal();
    }

    protected Future<Void> doEndWithUpload() {
        this.request.setChunked(true);
        String boundary = "boundary" + UUID.randomUUID();
        this.putHeader("Content-Type", "multipart/form-data; charset=UTF-8; boundary=" + boundary);
        return this.genBodyForm(boundary).onSuccess(v -> this.attachFiles(boundary)).onFailure(e -> this.asyncResp.consumerFail(e));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Future<Void> genBodyForm(String boundary) {
        if (this.formMap == null) {
            return Future.succeededFuture();
        }
        try (BufferOutputStream output = new BufferOutputStream();){
            for (Map.Entry<String, Object> entry : this.formMap.entrySet()) {
                output.write(this.bytesOf("\r\n"));
                output.write(this.bytesOf("--" + boundary + "\r\n"));
                output.write(this.bytesOf("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n"));
                if (entry.getValue() == null) continue;
                String value = RestObjectMapperFactory.getRestObjectMapper().convertToString(entry.getValue());
                output.write(value.getBytes(StandardCharsets.UTF_8));
            }
            Iterator<Map.Entry<String, Object>> iterator = this.writeBuffer(output.getBuffer());
            return iterator;
        }
        catch (Exception e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    private byte[] bytesOf(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    protected Future<Void> doEndNormal() {
        try {
            this.genBodyBuffer();
        }
        catch (Exception e) {
            this.asyncResp.consumerFail((Throwable)e);
            return Future.succeededFuture();
        }
        if (this.bodyBuffer == null) {
            return this.request.end();
        }
        return this.request.end(this.bodyBuffer);
    }

    private void attachFiles(String boundary) {
        Iterator<Map.Entry<String, Part>> uploadsIterator = this.uploads.entries().iterator();
        this.attachFile(boundary, uploadsIterator);
    }

    private void attachFile(String boundary, Iterator<Map.Entry<String, Part>> uploadsIterator) {
        if (!uploadsIterator.hasNext()) {
            this.writeBuffer(this.boundaryEndInfo(boundary)).onSuccess(v -> this.request.end()).onFailure(e -> this.asyncResp.consumerFail(e));
            return;
        }
        Map.Entry<String, Part> entry = uploadsIterator.next();
        String name = entry.getKey();
        Part part = entry.getValue();
        String filename = part.getSubmittedFileName();
        LOGGER.debug("Start attach file [{}:{}].", (Object)name, (Object)filename);
        this.writeBuffer(this.fileBoundaryInfo(boundary, name, part)).onSuccess(r -> new PumpFromPart(this.context, part).toWriteStream((WriteStream)this.request, this.throwableHandler).whenComplete((v, e) -> {
            if (e != null) {
                LOGGER.warn("Failed attach file [{}:{}].", new Object[]{name, filename, e});
                this.asyncResp.consumerFail(e);
                return;
            }
            LOGGER.debug("Finish attach file [{}:{}].", (Object)name, (Object)filename);
            this.attachFile(boundary, uploadsIterator);
        })).onFailure(e -> this.asyncResp.consumerFail(e));
    }

    private Buffer boundaryEndInfo(String boundary) {
        return Buffer.buffer().appendString("\r\n").appendString("--" + boundary + "--\r\n");
    }

    protected Buffer fileBoundaryInfo(String boundary, String name, Part part) {
        Buffer buffer = Buffer.buffer();
        buffer.appendString("\r\n");
        buffer.appendString("--" + boundary + "\r\n");
        buffer.appendString("Content-Disposition: form-data; name=\"").appendString(name).appendString("\"; filename=\"").appendString(part.getSubmittedFileName() != null ? part.getSubmittedFileName() : "null").appendString("\"\r\n");
        buffer.appendString("Content-Type: ").appendString(part.getContentType()).appendString("\r\n");
        buffer.appendString("Content-Transfer-Encoding: binary\r\n");
        buffer.appendString("\r\n");
        return buffer;
    }

    protected Future<Void> writeBuffer(Buffer buffer) {
        return new InputStreamToReadStream(this.context, (InputStream)new BufferInputStream(buffer.getByteBuf()), true).pipe().endOnComplete(false).to((WriteStream)this.request);
    }

    private void genBodyBuffer() throws Exception {
        if (this.bodyBuffer != null) {
            return;
        }
        if (this.formMap == null) {
            return;
        }
        this.request.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/x-www-form-urlencoded");
        try (BufferOutputStream output = new BufferOutputStream();){
            for (Map.Entry<String, Object> entry : this.formMap.entrySet()) {
                output.write(entry.getKey().getBytes(StandardCharsets.UTF_8));
                output.write(61);
                if (entry.getValue() != null) {
                    String value = RestObjectMapperFactory.getRestObjectMapper().convertToString(entry.getValue());
                    value = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
                    output.write(value.getBytes(StandardCharsets.UTF_8));
                }
                output.write(38);
            }
            this.bodyBuffer = output.getBuffer();
        }
    }

    private void writeCookies() {
        if (this.cookieMap == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.cookieMap.entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append("; ");
        }
        this.request.putHeader(HttpHeaders.COOKIE, (CharSequence)builder.toString());
    }

    public Context getContext() {
        return this.context;
    }

    public HttpClientRequest getRequest() {
        return this.request;
    }

    public Map<String, String> getCookieMap() {
        return this.cookieMap;
    }

    @Override
    public void addCookie(String name, String value) {
        if (this.cookieMap == null) {
            this.cookieMap = new HashMap<String, String>();
        }
        this.cookieMap.put(name, value);
    }

    @Override
    public void addForm(String name, Object value) {
        if (this.formMap == null) {
            this.formMap = new HashMap<String, Object>();
        }
        if (value != null) {
            this.formMap.put(name, value);
        }
    }

    @Override
    public void putHeader(String name, String value) {
        this.request.putHeader(name, value);
    }

    @Override
    public MultiMap getHeaders() {
        return this.request.headers();
    }
}

