/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec;

import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.definition.RestParam;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestCodec {
    private static final Logger LOG = LoggerFactory.getLogger(RestCodec.class);

    private RestCodec() {
    }

    public static void argsToRest(Map<String, Object> args, RestOperationMeta restOperation, RestClientRequest clientRequest) throws Exception {
        int paramSize = restOperation.getParamList().size();
        if (paramSize == 0) {
            return;
        }
        for (int idx = 0; idx < paramSize; ++idx) {
            RestParam param = restOperation.getParamList().get(idx);
            param.getParamProcessor().setValue(clientRequest, args.get(param.getParamName()));
        }
    }

    public static Map<String, Object> restToArgs(HttpServletRequest request, RestOperationMeta restOperation) throws InvocationException {
        List<RestParam> paramList = restOperation.getParamList();
        HashMap<String, Object> paramValues = new HashMap<String, Object>();
        for (RestParam param : paramList) {
            try {
                paramValues.put(param.getParamName(), param.getParamProcessor().getValue(request));
            }
            catch (InvocationException e) {
                throw e;
            }
            catch (Exception e) {
                String message = String.format("Parameter is not valid for operation [%s]. Parameter is [%s]. Processor is [%s].", restOperation.getOperationMeta().getMicroserviceQualifiedName(), param.getParamName(), param.getParamProcessor().getProcessorType());
                if (DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.codec.printErrorMessage", false).get()) {
                    LOG.error(message, (Throwable)e);
                } else {
                    LOG.error("{} Add {}=true to print the details.", (Object)message, (Object)"servicecomb.codec.printErrorMessage");
                }
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, message);
            }
        }
        return paramValues;
    }
}

