/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.model;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.servicecomb.router.model.PolicyRuleItem;
import org.apache.servicecomb.router.model.RouteItem;
import org.apache.servicecomb.router.model.TagItem;

public class ServiceInfoCache {
    private final List<PolicyRuleItem> allrule;
    private TagItem latestVersionTag;

    public ServiceInfoCache(List<PolicyRuleItem> policyRuleItemList) {
        this.allrule = policyRuleItemList.stream().sorted().collect(Collectors.toList());
        this.getAllrule().forEach(rule -> rule.getRoute().forEach(RouteItem::initTagItem));
    }

    public TagItem getNextInvokeVersion(PolicyRuleItem policyRuleItem) {
        List<RouteItem> rule = policyRuleItem.getRoute();
        if (policyRuleItem.getTotal() == null) {
            policyRuleItem.setTotal(rule.stream().mapToInt(RouteItem::getWeight).sum());
        }
        rule.stream().forEach(RouteItem::addCurrentWeight);
        int maxIndex = 0;
        int maxWeight = -1;
        for (int i = 0; i < rule.size(); ++i) {
            if (maxWeight >= rule.get(i).getCurrentWeight()) continue;
            maxIndex = i;
            maxWeight = rule.get(i).getCurrentWeight();
        }
        rule.get(maxIndex).reduceCurrentWeight(policyRuleItem.getTotal());
        return rule.get(maxIndex).getTagitem();
    }

    public List<PolicyRuleItem> getAllrule() {
        return this.allrule;
    }

    public TagItem getLatestVersionTag() {
        return this.latestVersionTag;
    }

    public void setLatestVersionTag(TagItem latestVersionTag) {
        this.latestVersionTag = latestVersionTag;
    }

    public String toString() {
        return "ServiceInfoCache{allrule=" + this.allrule + ", latestVersionTag=" + this.latestVersionTag + '}';
    }
}

