/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.model;

import java.util.List;
import org.apache.servicecomb.router.exception.RouterIllegalParamException;
import org.apache.servicecomb.router.model.Matcher;
import org.apache.servicecomb.router.model.RouteItem;
import org.apache.servicecomb.router.model.TagItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PolicyRuleItem
implements Comparable<PolicyRuleItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyRuleItem.class);
    private Integer precedence;
    private Matcher match;
    private List<RouteItem> route;
    private Integer total;
    private boolean weightLess = false;

    public void check(TagItem latestVersionTag) {
        if (CollectionUtils.isEmpty(this.route)) {
            throw new RouterIllegalParamException("canary rule list can not be null");
        }
        if (this.route.size() == 1) {
            this.route.get(0).setWeight(100);
            return;
        }
        int sum = 0;
        for (RouteItem item : this.route) {
            if (item.getWeight() == null) {
                throw new RouterIllegalParamException("canary rule weight can not be null");
            }
            sum += item.getWeight().intValue();
        }
        if (sum > 100) {
            LOGGER.warn("canary rule weight sum is more than 100");
        } else if (sum < 100) {
            if (latestVersionTag == null) {
                LOGGER.warn("canary has some error when set default latestVersion");
            }
            this.weightLess = true;
            this.route.add(new RouteItem(100 - sum, latestVersionTag));
        }
    }

    @Override
    public int compareTo(PolicyRuleItem param) {
        return Integer.compare(param.precedence, this.precedence);
    }

    public Integer getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(Integer precedence) {
        this.precedence = precedence;
    }

    public Matcher getMatch() {
        return this.match;
    }

    public void setMatch(Matcher match) {
        this.match = match;
    }

    public List<RouteItem> getRoute() {
        return this.route;
    }

    public void setRoute(List<RouteItem> route) {
        this.route = route;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public boolean isWeightLess() {
        return this.weightLess;
    }

    public void setWeightLess(boolean weightLess) {
        this.weightLess = weightLess;
    }

    public String toString() {
        return "PolicyRuleItem{precedence=" + this.precedence + ", match=" + this.match + ", route=" + this.route + ", total=" + this.total + ", weightLess=" + this.weightLess + '}';
    }
}

