/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.router.cache.RouterRuleCache;
import org.apache.servicecomb.router.distribute.RouterDistributor;
import org.apache.servicecomb.router.match.RouterRuleMatcher;
import org.apache.servicecomb.router.model.PolicyRuleItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RouterFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterFilter.class);
    private final RouterRuleMatcher routerRuleMatcher;
    private final RouterRuleCache routerRuleCache;

    @Autowired
    public RouterFilter(RouterRuleMatcher routerRuleMatcher, RouterRuleCache routerRuleCache) {
        this.routerRuleMatcher = routerRuleMatcher;
        this.routerRuleCache = routerRuleCache;
    }

    public <T, E> List<T> getFilteredListOfServers(List<T> list, String targetServiceName, Map<String, String> headers, RouterDistributor<T, E> distributer) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        if (StringUtils.isEmpty((CharSequence)targetServiceName)) {
            return list;
        }
        if (!this.routerRuleCache.doInit(targetServiceName)) {
            LOGGER.debug("route management init failed");
            return list;
        }
        PolicyRuleItem invokeRule = this.routerRuleMatcher.match(targetServiceName, headers);
        if (invokeRule == null) {
            LOGGER.debug("route management match rule failed");
            return list;
        }
        LOGGER.debug("route management match rule success: {}", (Object)invokeRule);
        List<T> resultList = distributer.distribute(targetServiceName, list, invokeRule);
        LOGGER.debug("route management distribute rule success: {}", resultList);
        return resultList;
    }
}

