/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.producer;

import com.netflix.config.DynamicPropertyFactory;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.foundation.common.utils.ClassLoaderScopeContext;
import org.apache.servicecomb.foundation.common.utils.IOUtils;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.api.registry.BasePath;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerBootListener
implements BootListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerBootListener.class);

    @Override
    public void onAfterTransport(BootListener.BootEvent event) {
        Microservice microservice = RegistrationManager.INSTANCE.getMicroservice();
        String swaggerSchema = "http";
        for (String endpoint : microservice.getInstance().getEndpoints()) {
            if (!endpoint.startsWith("rest://") || endpoint.indexOf("sslEnabled=true") <= 0) continue;
            swaggerSchema = "https";
            break;
        }
        MicroserviceMeta microserviceMeta = event.getScbEngine().getProducerMicroserviceMeta();
        for (SchemaMeta schemaMeta : microserviceMeta.getSchemaMetas().values()) {
            Swagger swagger = schemaMeta.getSwagger();
            swagger.addScheme(Scheme.forValue((String)swaggerSchema));
            String content = SwaggerUtils.swaggerToString((Swagger)swagger);
            LOGGER.info("generate swagger for {}/{}/{}, swagger: {}", new Object[]{microserviceMeta.getAppId(), microserviceMeta.getMicroserviceName(), schemaMeta.getSchemaId(), content});
            RegistrationManager.INSTANCE.addSchema(schemaMeta.getSchemaId(), content);
        }
        this.saveBasePaths(microserviceMeta);
    }

    private void saveBasePaths(MicroserviceMeta microserviceMeta) {
        if (!DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.registerPath", false).get()) {
            return;
        }
        String urlPrefix = ClassLoaderScopeContext.getClassLoaderScopeProperty((String)"urlPrefix");
        LinkedHashMap<String, BasePath> basePaths = new LinkedHashMap<String, BasePath>();
        for (SchemaMeta schemaMeta : microserviceMeta.getSchemaMetas().values()) {
            Swagger swagger = schemaMeta.getSwagger();
            String basePath = swagger.getBasePath();
            if (StringUtils.isNotEmpty((CharSequence)urlPrefix) && !basePath.startsWith(urlPrefix)) {
                basePath = urlPrefix + basePath;
            }
            if (!StringUtils.isNotEmpty((CharSequence)basePath)) continue;
            BasePath basePathObj = new BasePath();
            basePathObj.setPath(basePath);
            basePaths.put(basePath, basePathObj);
        }
        RegistrationManager.INSTANCE.addBasePath(basePaths.values());
    }

    @Override
    public void onAfterClose(BootListener.BootEvent event) {
        MicroserviceMeta microserviceMeta = event.getScbEngine().getProducerMicroserviceMeta();
        if (microserviceMeta == null) {
            return;
        }
        for (OperationMeta operationMeta : microserviceMeta.getOperations()) {
            if (operationMeta.getExecutor() instanceof ExecutorService) {
                ((ExecutorService)operationMeta.getExecutor()).shutdown();
                continue;
            }
            if (operationMeta.getExecutor() instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)((Object)operationMeta.getExecutor())));
                continue;
            }
            LOGGER.warn("Executor {} do not support close or shutdown, it may block service shutdown.", (Object)operationMeta.getExecutor().getClass().getName());
        }
    }
}

