/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.micrometer.tagged.TaggedTimeLimiterMetrics;
import io.github.resilience4j.micrometer.tagged.TimeLimiterMetricNames;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableTimeLimiter;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.TimeLimiterPolicy;
import org.apache.servicecomb.governance.properties.TimeLimiterProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeLimiterHandler
extends AbstractGovernanceHandler<TimeLimiter, TimeLimiterPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeLimiterHandler.class);
    private final TimeLimiterProperties timeLimiterProperties;

    public TimeLimiterHandler(TimeLimiterProperties timeLimiterProperties) {
        this.timeLimiterProperties = timeLimiterProperties;
    }

    @Override
    protected String createKey(GovernanceRequest governanceRequest, TimeLimiterPolicy policy) {
        return this.timeLimiterProperties.getConfigKey() + "." + policy.getName();
    }

    @Override
    public TimeLimiterPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (TimeLimiterPolicy)this.matchersManager.match(governanceRequest, this.timeLimiterProperties.getParsedEntity());
    }

    @Override
    public Disposable<TimeLimiter> createProcessor(String key, GovernanceRequest governanceRequest, TimeLimiterPolicy policy) {
        return this.getTimeLimiter(key, policy);
    }

    private Disposable<TimeLimiter> getTimeLimiter(String key, TimeLimiterPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy);
        TimeLimiterConfig timeLimiterConfig = TimeLimiterConfig.custom().timeoutDuration(Duration.parse(policy.getTimeoutDuration())).cancelRunningFuture(policy.isCancelRunningFuture()).build();
        TimeLimiterRegistry timeLimiterRegistry = TimeLimiterRegistry.of((TimeLimiterConfig)timeLimiterConfig);
        if (this.meterRegistry != null) {
            TaggedTimeLimiterMetrics.ofTimeLimiterRegistry((TimeLimiterMetricNames)TimeLimiterMetricNames.custom().callsMetricName(this.timeLimiterProperties.getConfigKey() + ".calls").build(), (TimeLimiterRegistry)timeLimiterRegistry).bindTo(this.meterRegistry);
        }
        return new DisposableTimeLimiter(key, timeLimiterRegistry, timeLimiterRegistry.timeLimiter(key));
    }
}

