/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter.inner;

import com.netflix.config.DynamicPropertyFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.common.rest.filter.inner.RestServerCodecFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.utils.PartUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class ServerRestArgsFilter
implements HttpServerFilter {
    private static final boolean enabled = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.http.filter.server.serverRestArgs.enabled", true).get();

    @Override
    public int getOrder() {
        return -100;
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public boolean enabledForTransport(String transport) {
        return HttpServerFilter.super.enabledForTransport(transport) || "websocket".equals(transport);
    }

    @Override
    public Response afterReceiveRequest(Invocation invocation, HttpServletRequestEx requestEx) {
        OperationMeta operationMeta = invocation.getOperationMeta();
        RestOperationMeta restOperationMeta = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        Map<String, Object> swaggerArguments = RestCodec.restToArgs((HttpServletRequest)requestEx, restOperationMeta);
        invocation.setSwaggerArguments(swaggerArguments);
        return null;
    }

    @Override
    public CompletableFuture<Void> beforeSendResponseAsync(Invocation invocation, HttpServletResponseEx responseEx) {
        Response response = (Response)responseEx.getAttribute("servicecomb-invocation-hanlder-response");
        ProduceProcessor produceProcessor = (ProduceProcessor)responseEx.getAttribute("servicecomb-invocation-hanlder-processor");
        boolean failed = response.getResult() instanceof InvocationException;
        if (!failed && RestServerCodecFilter.isDownloadFileResponseType(invocation, response)) {
            return responseEx.sendPart(PartUtils.getSinglePart(null, (Object)response.getResult()));
        }
        responseEx.setContentType(produceProcessor.getName() + "; charset=utf-8");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try (BufferOutputStream output = new BufferOutputStream((ByteBuf)Unpooled.compositeBuffer());){
            if (failed) {
                produceProcessor.encodeResponse((OutputStream)output, ((InvocationException)((Object)response.getResult())).getErrorData());
            } else {
                produceProcessor.encodeResponse((OutputStream)output, response.getResult());
            }
            responseEx.setBodyBuffer(output.getBuffer());
            future.complete(null);
        }
        catch (Throwable e) {
            future.completeExceptionally(ExceptionFactory.convertProducerException((Throwable)e));
        }
        return future;
    }
}

