/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.apache.servicecomb.http.client.common.URLEndPoint;
import org.apache.servicecomb.http.client.event.EngineConnectChangedEvent;
import org.apache.servicecomb.http.client.event.RefreshEndpointEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAddressManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAddressManager.class);
    public static final String DEFAULT_PROJECT = "default";
    public static final String V4_PREFIX = "/v4/";
    private static final String V3_PREFIX = "/v3/";
    private static final int ISOLATION_THRESHOLD = 3;
    private volatile List<String> addresses = new ArrayList<String>();
    private final List<String> defaultAddress = new ArrayList<String>();
    private final List<String> defaultIsolationAddress = new ArrayList<String>();
    private int index;
    private String projectName;
    private final Map<String, Integer> addressFailureStatus = new ConcurrentHashMap<String, Integer>();
    private volatile List<String> availableZone = new ArrayList<String>();
    private final List<String> isolationZoneAddress = new ArrayList<String>();
    private volatile List<String> availableRegion = new ArrayList<String>();
    private final List<String> isolationRegionAddress = new ArrayList<String>();
    private boolean addressAutoRefreshed = false;
    private final Object lock = new Object();
    private final Random random = new Random();
    private EventBus eventBus;

    public AbstractAddressManager(List<String> addresses) {
        this.projectName = DEFAULT_PROJECT;
        this.addresses.addAll(addresses);
        this.defaultAddress.addAll(addresses);
        this.index = !addresses.isEmpty() ? this.getRandomIndex() : 0;
    }

    public AbstractAddressManager(String projectName, List<String> addresses) {
        this.projectName = StringUtils.isEmpty((String)projectName) ? DEFAULT_PROJECT : projectName;
        this.addresses = this.transformAddress(addresses);
        this.defaultAddress.addAll(addresses);
        this.index = !addresses.isEmpty() ? this.getRandomIndex() : 0;
    }

    private int getRandomIndex() {
        return this.random.nextInt(this.addresses.size());
    }

    public void refreshEndpoint(RefreshEndpointEvent event, String key) {
        if (null == event || !event.getName().equals(key)) {
            return;
        }
        this.availableZone = event.getSameZone().stream().map(this::normalizeUri).collect(Collectors.toList());
        this.availableRegion = event.getSameRegion().stream().map(this::normalizeUri).collect(Collectors.toList());
        this.addressAutoRefreshed = true;
    }

    protected String normalizeUri(String endpoint) {
        return new URLEndPoint(endpoint).toString();
    }

    @VisibleForTesting
    Map<String, Integer> getAddressFailureStatus() {
        return this.addressFailureStatus;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public List<String> getAvailableZone() {
        return this.availableZone;
    }

    public List<String> getAvailableRegion() {
        return this.availableRegion;
    }

    public String formatUrl(String url, boolean absoluteUrl, String address) {
        return absoluteUrl ? address + url : this.formatAddress(address) + url;
    }

    public boolean sslEnabled() {
        return this.address().startsWith("https://");
    }

    protected List<String> transformAddress(List<String> addresses) {
        return addresses.stream().map(this::formatAddress).collect(Collectors.toList());
    }

    protected String formatAddress(String address) {
        try {
            return this.getUrlPrefix(address) + HttpUtils.encodeURLParam(this.projectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("not possible");
        }
    }

    protected String getUrlPrefix(String address) {
        return address + V3_PREFIX;
    }

    public String address() {
        if (!this.addressAutoRefreshed) {
            return this.getDefaultAddress();
        }
        return this.getAvailableZoneAddress();
    }

    private String getDefaultAddress() {
        if (!this.addresses.isEmpty()) {
            return this.getCurrentAddress(this.addresses);
        }
        LOGGER.warn("all addresses are isolation, please check server status.");
        return this.getCurrentAddress(this.defaultAddress);
    }

    private String getAvailableZoneAddress() {
        List<String> zoneOrRegionAddress = this.getZoneOrRegionAddress();
        if (!zoneOrRegionAddress.isEmpty()) {
            return this.getCurrentAddress(zoneOrRegionAddress);
        }
        LOGGER.warn("all auto discovery addresses are isolation, please check server status.");
        return this.getCurrentAddress(this.addresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentAddress(List<String> addresses) {
        AbstractAddressManager abstractAddressManager = this;
        synchronized (abstractAddressManager) {
            ++this.index;
            if (this.index >= addresses.size()) {
                this.index = 0;
            }
            return addresses.get(this.index);
        }
    }

    private List<String> getZoneOrRegionAddress() {
        ArrayList<String> results = new ArrayList<String>();
        if (!this.availableZone.isEmpty()) {
            results.addAll(this.availableZone);
        } else {
            results.addAll(this.availableRegion);
        }
        return results;
    }

    public void recoverIsolatedAddress(String address) {
        this.recordSuccessState(address);
        if (this.addressAutoRefreshed) {
            if (this.isolationZoneAddress.remove(address)) {
                LOGGER.warn("restore same region address [{}]", (Object)address);
                if (this.eventBus != null && this.availableZone.isEmpty()) {
                    this.eventBus.post((Object)new EngineConnectChangedEvent());
                }
                this.availableZone.add(address);
                return;
            }
            if (this.isolationRegionAddress.remove(address)) {
                LOGGER.warn("restore same zone address [{}]", (Object)address);
                this.availableRegion.add(address);
            }
            return;
        }
        if (this.defaultIsolationAddress.remove(address)) {
            LOGGER.warn("restore default address [{}]", (Object)address);
            this.addresses.add(address);
        }
    }

    public void recordSuccessState(String address) {
        this.addressFailureStatus.put(address, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordFailState(String address) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.addressFailureStatus.containsKey(address)) {
                this.addressFailureStatus.put(address, 1);
                return;
            }
            int number = this.addressFailureStatus.get(address) + 1;
            if (number < 3) {
                this.addressFailureStatus.put(address, number);
            } else {
                this.removeAddress(address);
            }
        }
    }

    @VisibleForTesting
    void removeAddress(String address) {
        if (!this.addressAutoRefreshed) {
            if (this.addresses.remove(address)) {
                LOGGER.warn("isolation default address [{}]", (Object)address);
                this.defaultIsolationAddress.add(address);
            }
            return;
        }
        if (this.availableZone.remove(address)) {
            LOGGER.warn("isolation same zone address [{}]", (Object)address);
            this.isolationZoneAddress.add(address);
            if (this.eventBus != null && this.availableZone.isEmpty() && !this.availableRegion.isEmpty()) {
                this.eventBus.post((Object)new EngineConnectChangedEvent());
            }
            return;
        }
        if (this.availableRegion.remove(address)) {
            LOGGER.warn("isolation same region address [{}]", (Object)address);
            this.isolationRegionAddress.add(address);
        }
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public List<String> getIsolationAddresses() {
        ArrayList<String> isolationAddresses = new ArrayList<String>(this.defaultIsolationAddress);
        isolationAddresses.addAll(this.isolationZoneAddress);
        isolationAddresses.addAll(this.isolationRegionAddress);
        return isolationAddresses;
    }
}

