/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public class RestTemplateCopyHeaderFilter
implements HttpClientFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTemplateCopyHeaderFilter.class);

    public int getOrder() {
        return -10000;
    }

    public CompletableFuture<Void> beforeSendRequestAsync(Invocation invocation, HttpServletRequestEx requestEx) {
        HttpHeaders httpHeaders = (HttpHeaders)invocation.getHandlerContext().get("servicecomb-rest-consumer-header");
        if (httpHeaders == null) {
            return CompletableFuture.completedFuture(null);
        }
        httpHeaders.forEach((key, values) -> {
            if ("Content-Length".equalsIgnoreCase((String)key)) {
                LOGGER.debug("skip copy content-length into request");
                return;
            }
            for (String value : values) {
                if (null == value) {
                    LOGGER.debug("header value is null, key = [{}]. Will not set this header into request", key);
                    continue;
                }
                requestEx.addHeader(key, value);
            }
        });
        return CompletableFuture.completedFuture(null);
    }

    public Response afterReceiveResponse(Invocation invocation, HttpServletResponseEx responseEx) {
        return null;
    }
}

