/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;

public class HttpClientFilterBeforeSendRequestExecutor {
    private final List<HttpClientFilter> httpClientFilters;
    private final Invocation invocation;
    private final HttpServletRequestEx requestEx;
    private int currentIndex;
    private final CompletableFuture<Void> future = new CompletableFuture();

    public HttpClientFilterBeforeSendRequestExecutor(List<HttpClientFilter> httpClientFilters, Invocation invocation, HttpServletRequestEx requestEx) {
        this.httpClientFilters = httpClientFilters;
        this.invocation = invocation;
        this.requestEx = requestEx;
    }

    public CompletableFuture<Void> run() {
        this.doRun();
        return this.future;
    }

    protected CompletableFuture<Void> safeInvoke(HttpClientFilter httpClientFilter) {
        try {
            if (httpClientFilter.enabled()) {
                CompletableFuture<Void> future = httpClientFilter.beforeSendRequestAsync(this.invocation, this.requestEx);
                if (future == null) {
                    future = new CompletableFuture();
                    future.completeExceptionally(new IllegalStateException("HttpClientFilter beforeSendRequestAsync can not return null. Class=" + httpClientFilter.getClass().getName()));
                }
                return future;
            }
            CompletableFuture<Void> eFuture = new CompletableFuture<Void>();
            eFuture.complete(null);
            return eFuture;
        }
        catch (Throwable e) {
            CompletableFuture<Void> eFuture = new CompletableFuture<Void>();
            eFuture.completeExceptionally(e);
            return eFuture;
        }
    }

    protected void doRun() {
        if (this.currentIndex == this.httpClientFilters.size()) {
            this.future.complete(null);
            return;
        }
        HttpClientFilter httpServerFilter = this.httpClientFilters.get(this.currentIndex);
        ++this.currentIndex;
        CompletableFuture<Void> stepFuture = this.safeInvoke(httpServerFilter);
        stepFuture.whenComplete((v, e) -> {
            if (e == null) {
                this.doRun();
                return;
            }
            this.future.completeExceptionally((Throwable)e);
        });
    }
}

