/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler.ext;

import com.google.common.collect.ImmutableMap;
import io.vertx.core.VertxException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface FailurePredictor {
    public static final Map<Class<? extends Throwable>, List<String>> STRICT_RETRIABLE = ImmutableMap.builder().put(ConnectException.class, Collections.emptyList()).put(SocketTimeoutException.class, Collections.emptyList()).put(IOException.class, Collections.singletonList("Connection reset by peer")).put(VertxException.class, Collections.singletonList("Connection was closed")).put(NoRouteToHostException.class, Collections.emptyList()).build();

    public boolean isFailedResult(List<String> var1, Object var2);

    default public boolean isFailedResult(Throwable e) {
        return FailurePredictor.canRetryForException(STRICT_RETRIABLE, e);
    }

    public static boolean canRetryForException(Map<Class<? extends Throwable>, List<String>> retryList, Throwable throwableToSearchIn) {
        int infiniteLoopPreventionCounter = 10;
        while (throwableToSearchIn != null && infiniteLoopPreventionCounter > 0) {
            --infiniteLoopPreventionCounter;
            for (Map.Entry<Class<? extends Throwable>, List<String>> c : retryList.entrySet()) {
                Class<? extends Throwable> key = c.getKey();
                if (!key.isAssignableFrom(throwableToSearchIn.getClass())) continue;
                if (c.getValue() == null || c.getValue().isEmpty()) {
                    return true;
                }
                String msg = throwableToSearchIn.getMessage();
                for (String val : c.getValue()) {
                    if (!val.equals(msg)) continue;
                    return true;
                }
            }
            throwableToSearchIn = throwableToSearchIn.getCause();
        }
        return false;
    }
}

