/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os.cpu;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CpuUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CpuUtils.class);
    public static final File PROC_STAT = new File("/proc/stat");
    public static final File UPTIME = new File("/proc/uptime");
    public static final File SELF_PROCESS = new File("/proc/self/stat");

    private CpuUtils() {
    }

    public static String[] readAndSplitFirstLine(File file) throws IOException {
        return Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).readFirstLine().trim().split("\\s+");
    }

    public static double summary(String[] stats, int start, int len) {
        double total = 0.0;
        for (int idx = start; idx < start + len; ++idx) {
            total += Double.parseDouble(stats[idx]);
        }
        return total;
    }

    public static double readProcSelfBusy() throws IOException {
        String[] stats = CpuUtils.readAndSplitFirstLine(SELF_PROCESS);
        return CpuUtils.summary(stats, 13, 2);
    }

    public static double readProcStatTotal() throws IOException {
        String[] stats = CpuUtils.readAndSplitFirstLine(PROC_STAT);
        return CpuUtils.summary(stats, 1, 8);
    }

    public static double readUptimeTotal() throws IOException {
        String[] uptime = CpuUtils.readAndSplitFirstLine(UPTIME);
        return Double.parseDouble(uptime[0]);
    }

    private static boolean isBetween(long x, long lower, long upper) {
        return lower <= x && x <= upper;
    }

    public static int calcHertz() {
        double up2;
        double jiffies;
        double up1;
        while (true) {
            try {
                up1 = CpuUtils.readUptimeTotal();
                jiffies = CpuUtils.readProcStatTotal();
                up2 = CpuUtils.readUptimeTotal();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to calc hertz, should never happened, try again.", e);
                continue;
            }
            if (0L == (long)((up2 - up1) * 1000.0 / up1)) break;
        }
        double seconds = (up1 + up2) / 2.0;
        long hz = Math.round(jiffies / seconds / (double)Runtime.getRuntime().availableProcessors());
        if (CpuUtils.isBetween(hz, 9L, 11L)) {
            return 10;
        }
        if (CpuUtils.isBetween(hz, 18L, 22L)) {
            return 20;
        }
        if (CpuUtils.isBetween(hz, 30L, 34L)) {
            return 32;
        }
        if (CpuUtils.isBetween(hz, 48L, 52L)) {
            return 50;
        }
        if (CpuUtils.isBetween(hz, 58L, 61L)) {
            return 60;
        }
        if (CpuUtils.isBetween(hz, 62L, 65L)) {
            return 64;
        }
        if (CpuUtils.isBetween(hz, 95L, 105L)) {
            return 100;
        }
        if (CpuUtils.isBetween(hz, 124L, 132L)) {
            return 128;
        }
        if (CpuUtils.isBetween(hz, 195L, 204L)) {
            return 200;
        }
        if (CpuUtils.isBetween(hz, 247L, 252L)) {
            return 250;
        }
        if (CpuUtils.isBetween(hz, 253L, 260L)) {
            return 256;
        }
        if (CpuUtils.isBetween(hz, 393L, 408L)) {
            return 400;
        }
        if (CpuUtils.isBetween(hz, 410L, 600L)) {
            return 500;
        }
        if (CpuUtils.isBetween(hz, 790L, 808L)) {
            return 800;
        }
        if (CpuUtils.isBetween(hz, 990L, 1010L)) {
            return 1000;
        }
        if (CpuUtils.isBetween(hz, 1015L, 1035L)) {
            return 1024;
        }
        if (CpuUtils.isBetween(hz, 1180L, 1220L)) {
            return 1200;
        }
        LOGGER.warn("Unknown HZ value! ({}) Assume {}.\n", (Object)hz, (Object)100);
        return 100;
    }
}

