/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.discovery;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryTree.class);
    private volatile DiscoveryTreeNode root;
    private final Object lock = new Object();
    private final List<DiscoveryFilter> filters = new ArrayList<DiscoveryFilter>();

    public void loadFromSPI(Class<? extends DiscoveryFilter> cls) {
        this.filters.addAll(SPIServiceUtils.getSortedService(cls));
    }

    public void addFilter(DiscoveryFilter filter) {
        this.filters.add(filter);
    }

    public void sort() {
        this.filters.sort(Comparator.comparingInt(DiscoveryFilter::getOrder));
        Iterator<DiscoveryFilter> iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            DiscoveryFilter filter = iterator.next();
            if (!filter.enabled()) {
                iterator.remove();
            }
            LOGGER.info("DiscoveryFilter {}, enabled {}.", (Object)filter.getClass().getName(), (Object)filter.enabled());
        }
    }

    protected boolean isMatch(VersionedCache existing, VersionedCache inputCache) {
        return existing != null && existing.isSameVersion(inputCache);
    }

    protected boolean isExpired(VersionedCache existing, VersionedCache inputCache) {
        return existing == null || existing.isExpired(inputCache);
    }

    public DiscoveryTreeNode discovery(DiscoveryContext context, String appId, String microserviceName, String versionRule) {
        VersionedCache instanceVersionedCache = DiscoveryManager.INSTANCE.getInstanceCacheManager().getOrCreateVersionedCache(appId, microserviceName, versionRule);
        return this.discovery(context, instanceVersionedCache);
    }

    public DiscoveryTreeNode discovery(DiscoveryContext context, VersionedCache inputCache) {
        DiscoveryTreeNode tmpRoot = this.getOrCreateRoot(inputCache);
        DiscoveryTreeNode parent = tmpRoot.children().computeIfAbsent(inputCache.name(), name -> new DiscoveryTreeNode().fromCache(inputCache));
        return this.doDiscovery(context, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiscoveryTreeNode getOrCreateRoot(VersionedCache inputCache) {
        DiscoveryTreeNode tmpRoot = this.root;
        if (this.isMatch(tmpRoot, inputCache)) {
            return tmpRoot;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isExpired(this.root, inputCache)) {
                this.root = (DiscoveryTreeNode)new DiscoveryTreeNode().cacheVersion(inputCache.cacheVersion());
                return this.root;
            }
            if (this.root.isSameVersion(inputCache)) {
                return this.root;
            }
        }
        return (DiscoveryTreeNode)new DiscoveryTreeNode().cacheVersion(inputCache.cacheVersion());
    }

    protected DiscoveryTreeNode doDiscovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        int idx = 0;
        while (idx < this.filters.size()) {
            DiscoveryTreeNode rerunNode;
            DiscoveryFilter filter = this.filters.get(idx);
            context.setCurrentNode(parent);
            DiscoveryTreeNode child = filter.discovery(context, parent);
            if (child == null) {
                throw new ServiceCombException(filter.getClass().getName() + " discovery return null.");
            }
            child.level(idx + 1);
            if (!filter.isGroupingFilter()) {
                child.name(parent.name());
            }
            if (child.isEmpty() && (rerunNode = context.popRerunFilter()) != null) {
                parent = rerunNode;
                idx = parent.level();
                continue;
            }
            parent = child;
            ++idx;
        }
        return parent;
    }
}

