/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import com.google.common.annotations.VisibleForTesting;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.qps.Config;
import org.apache.servicecomb.qps.QpsConst;
import org.apache.servicecomb.qps.QpsControllerManager;
import org.apache.servicecomb.qps.QpsStrategy;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class ProviderQpsFlowControlHandler
implements Handler {
    private final QpsControllerManager qpsControllerMgr = new QpsControllerManager(true);

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        if (invocation.getHandlerIndex() > 0) {
            invocation.next(asyncResp);
            return;
        }
        if (!Config.INSTANCE.isProviderEnabled()) {
            return;
        }
        String microserviceName = invocation.getContext("x-cse-src-microservice");
        QpsStrategy qpsStrategy = this.qpsControllerMgr.getOrCreate(microserviceName, invocation);
        this.isLimitNewRequest(qpsStrategy, asyncResp);
    }

    private boolean isLimitNewRequest(QpsStrategy qpsStrategy, AsyncResponse asyncResp) {
        if (qpsStrategy.isLimitNewRequest()) {
            CommonExceptionData errorData = new CommonExceptionData("provider request rejected by qps flowcontrol");
            asyncResp.producerFail((Throwable)new InvocationException(QpsConst.TOO_MANY_REQUESTS_STATUS, (Object)errorData));
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public QpsControllerManager getQpsControllerMgr() {
        return this.qpsControllerMgr;
    }
}

