/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.transport;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.registry.RegistrationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportManager.class);
    private final List<Transport> transports = new ArrayList<Transport>(SPIServiceUtils.getOrLoadSortedService(Transport.class));
    private final Map<String, Transport> transportMap = new HashMap<String, Transport>();

    public void clearTransportBeforeInit() {
        this.transports.clear();
    }

    public void addTransportBeforeInit(Transport transport) {
        this.transports.add(transport);
    }

    public void addTransportsBeforeInit(List<Transport> transports) {
        this.transports.addAll(transports);
    }

    public void init(SCBEngine scbEngine) throws Exception {
        this.buildTransportMap();
        for (Transport transport : this.transportMap.values()) {
            Endpoint endpoint;
            if (!transport.init() || (endpoint = transport.getPublishEndpoint()) == null || endpoint.getEndpoint() == null) continue;
            LOGGER.info("endpoint to publish: {}", (Object)endpoint.getEndpoint());
            RegistrationManager.INSTANCE.addEndpoint(endpoint.getEndpoint());
        }
    }

    protected void buildTransportMap() {
        Map<String, List<Transport>> groups = this.groupByName();
        for (Map.Entry<String, List<Transport>> entry : groups.entrySet()) {
            List<Transport> group = entry.getValue();
            this.checkTransportGroup(group);
            Transport transport = this.chooseOneTransport(group);
            this.transportMap.put(transport.getName(), transport);
        }
    }

    protected Transport chooseOneTransport(List<Transport> group) {
        group.sort(Comparator.comparingInt(Transport::getOrder));
        for (Transport transport : group) {
            if (!transport.canInit()) continue;
            LOGGER.info("choose {} for {}.", (Object)transport.getClass().getName(), (Object)transport.getName());
            return transport;
        }
        throw new ServiceCombException(String.format("all transport named %s refused to init.", group.get(0).getName()));
    }

    protected void checkTransportGroup(List<Transport> group) {
        HashMap<Integer, Transport> orderMap = new HashMap<Integer, Transport>();
        for (Transport transport : group) {
            Transport existTransport = orderMap.putIfAbsent(transport.getOrder(), transport);
            if (existTransport == null) continue;
            throw new ServiceCombException(String.format("%s and %s have the same order %d", existTransport.getClass().getName(), transport.getClass().getName(), transport.getOrder()));
        }
    }

    protected Map<String, List<Transport>> groupByName() {
        HashMap<String, List<Transport>> groups = new HashMap<String, List<Transport>>();
        for (Transport transport : this.transports) {
            List list = groups.computeIfAbsent(transport.getName(), name -> new ArrayList());
            list.add(transport);
        }
        return groups;
    }

    public Transport findTransport(String transportName) {
        return this.transportMap.get(transportName);
    }
}

