/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.servicecomb.common.rest.AbstractRestInvocation;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReactiveResponseExecutor;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.foundation.vertx.executor.VertxContextExecutor;
import org.apache.servicecomb.foundation.vertx.http.VertxServerRequestToHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.http.VertxServerResponseToHttpServletResponse;

public class EdgeInvocation
extends AbstractRestInvocation {
    public static final String EDGE_INVOCATION_CONTEXT = "edgeInvocationContext";
    protected String microserviceName;
    protected MicroserviceReferenceConfig microserviceReferenceConfig;
    protected String versionRule = null;
    protected RoutingContext routingContext;

    public void init(String microserviceName, RoutingContext context, String path, List<HttpServerFilter> httpServerFilters) {
        this.microserviceName = microserviceName;
        this.requestEx = new VertxServerRequestToHttpServletRequest(context, path);
        this.responseEx = new VertxServerResponseToHttpServletResponse(context.response());
        this.routingContext = context;
        this.httpServerFilters = httpServerFilters;
        this.requestEx.setAttribute("servicecomb-rest-request", (Object)this.requestEx);
    }

    public void edgeInvoke() {
        this.findMicroserviceVersionMeta().whenCompleteAsync((r, e) -> {
            if (e != null) {
                this.sendFailResponse((Throwable)e);
            } else {
                try {
                    this.microserviceReferenceConfig = r;
                    this.findRestOperation(this.microserviceReferenceConfig.getLatestMicroserviceMeta());
                    this.scheduleInvocation();
                }
                catch (Throwable error) {
                    this.sendFailResponse(error);
                }
            }
        }, (Executor)VertxContextExecutor.create((Context)Vertx.currentContext()));
    }

    protected CompletableFuture<MicroserviceReferenceConfig> findMicroserviceVersionMeta() {
        return SCBEngine.getInstance().createMicroserviceReferenceConfigAsync(this.microserviceName, this.chooseVersionRule());
    }

    public void setVersionRule(String versionRule) {
        this.versionRule = versionRule;
    }

    protected String chooseVersionRule() {
        return this.versionRule;
    }

    protected OperationLocator locateOperation(ServicePathManager servicePathManager) {
        return servicePathManager.consumerLocateOperation(this.requestEx.getRequestURI(), this.requestEx.getMethod());
    }

    protected void createInvocation() {
        ReferenceConfig referenceConfig = this.microserviceReferenceConfig.createReferenceConfig(this.restOperationMeta.getOperationMeta());
        this.invocation = InvocationFactory.forConsumer((ReferenceConfig)referenceConfig, (OperationMeta)this.restOperationMeta.getOperationMeta(), (InvocationRuntimeType)this.restOperationMeta.getOperationMeta().buildBaseConsumerRuntimeType(), null);
        this.invocation.setSync(false);
        this.invocation.setEdge(true);
        this.invocation.getHandlerContext().put(EDGE_INVOCATION_CONTEXT, Vertx.currentContext());
        this.invocation.setResponseExecutor((Executor)new ReactiveResponseExecutor());
        this.routingContext.put("servicecomb-rest-invocation-context", (Object)this.invocation);
    }

    public void setContext() throws Exception {
    }
}

