/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.servicecomb.config.common.exception.OperationException;
import org.apache.servicecomb.config.kie.client.KieConfigOperation;
import org.apache.servicecomb.config.kie.client.model.ConfigurationsRequest;
import org.apache.servicecomb.config.kie.client.model.ConfigurationsResponse;
import org.apache.servicecomb.config.kie.client.model.KVDoc;
import org.apache.servicecomb.config.kie.client.model.KVResponse;
import org.apache.servicecomb.config.kie.client.model.KieAddressManager;
import org.apache.servicecomb.config.kie.client.model.KieConfiguration;
import org.apache.servicecomb.config.kie.client.model.ValueType;
import org.apache.servicecomb.http.client.common.HttpRequest;
import org.apache.servicecomb.http.client.common.HttpResponse;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class KieClient
implements KieConfigOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieClient.class);
    protected HttpTransport httpTransport;
    protected String revision = "0";
    private final KieAddressManager addressManager;
    private final KieConfiguration kieConfiguration;
    public static final String DEFAULT_KIE_API_VERSION = "v1";

    public KieClient(KieAddressManager addressManager, HttpTransport httpTransport, KieConfiguration kieConfiguration) {
        this.httpTransport = httpTransport;
        this.addressManager = addressManager;
        this.kieConfiguration = kieConfiguration;
    }

    @Override
    public ConfigurationsResponse queryConfigurations(ConfigurationsRequest request) {
        String address = this.addressManager.address();
        String url = this.buildUrl(request, address);
        try {
            if (this.kieConfiguration.isEnableLongPolling()) {
                url = url + "&wait=" + this.kieConfiguration.getPollingWaitInSeconds() + "s";
            }
            HttpRequest httpRequest = new HttpRequest(url, null, null, "GET");
            HttpResponse httpResponse = this.httpTransport.doRequest(httpRequest);
            ConfigurationsResponse configurationsResponse = new ConfigurationsResponse();
            if (httpResponse.getStatusCode() == 200) {
                this.revision = httpResponse.getHeader("X-Kie-Revision");
                KVResponse allConfigList = (KVResponse)HttpUtils.deserialize((String)httpResponse.getContent(), KVResponse.class);
                Map<String, Object> configurations = this.getConfigByLabel(allConfigList);
                configurationsResponse.setConfigurations(configurations);
                configurationsResponse.setChanged(true);
                configurationsResponse.setRevision(this.revision);
                this.addressManager.recordSuccessState(address);
                return configurationsResponse;
            }
            if (httpResponse.getStatusCode() == 400) {
                throw new OperationException("Bad request for query configurations.");
            }
            if (httpResponse.getStatusCode() == 304) {
                configurationsResponse.setChanged(false);
                this.addressManager.recordSuccessState(address);
                return configurationsResponse;
            }
            this.addressManager.recordFailState(address);
            throw new OperationException("read response failed. status:" + httpResponse.getStatusCode() + "; message:" + httpResponse.getMessage() + "; content:" + httpResponse.getContent());
        }
        catch (Exception e) {
            LOGGER.error("query configuration from {} failed, message={}", (Object)url, (Object)e.getMessage());
            throw new OperationException("read response failed. ", (Throwable)e);
        }
    }

    private String buildUrl(ConfigurationsRequest request, String currentAddress) {
        StringBuilder sb = new StringBuilder();
        sb.append(currentAddress);
        sb.append("/");
        sb.append(DEFAULT_KIE_API_VERSION);
        sb.append("/");
        sb.append(this.kieConfiguration.getProject());
        sb.append("/kie/kv?");
        sb.append(request.getLabelsQuery());
        sb.append("&revision=");
        sb.append(request.getRevision());
        if (request.isWithExact()) {
            sb.append("&match=exact");
        }
        return sb.toString();
    }

    private Map<String, Object> getConfigByLabel(KVResponse resp) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resp.getData().stream().filter(doc -> doc.getStatus() == null || "enabled".equalsIgnoreCase(doc.getStatus())).map(this::processValueType).collect(Collectors.toList()).forEach(resultMap::putAll);
        return resultMap;
    }

    private Map<String, Object> processValueType(KVDoc kvDoc) {
        ValueType valueType;
        try {
            valueType = ValueType.valueOf(kvDoc.getValueType());
        }
        catch (IllegalArgumentException e) {
            throw new OperationException("value type not support [" + kvDoc.getValue() + "]");
        }
        Properties properties = new Properties();
        HashMap<String, Object> kvMap = new HashMap<String, Object>();
        try {
            switch (valueType) {
                case yml: 
                case yaml: {
                    YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
                    yamlFactory.setResources(new Resource[]{new ByteArrayResource(kvDoc.getValue().getBytes(StandardCharsets.UTF_8))});
                    return this.toMap(yamlFactory.getObject());
                }
                case properties: {
                    properties.load(new StringReader(kvDoc.getValue()));
                    return this.toMap(properties);
                }
            }
            kvMap.put(kvDoc.getKey(), kvDoc.getValue());
            return kvMap;
        }
        catch (Exception e) {
            LOGGER.error("read config failed", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Map<String, Object> toMap(Properties properties) {
        if (properties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            result.put(key, value);
        }
        return result;
    }
}

