/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.config.inject.InjectProperties;
import org.apache.servicecomb.config.inject.InjectProperty;
import org.apache.servicecomb.config.inject.PlaceholderResolver;
import org.apache.servicecomb.config.priority.ConfigObject;
import org.apache.servicecomb.config.priority.ConfigObjectProperty;
import org.apache.servicecomb.config.priority.PriorityProperty;
import org.apache.servicecomb.config.priority.PriorityPropertyFactory;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.common.utils.LambdaMetafactoryUtils;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.springframework.stereotype.Component;

@Component
public class ConfigObjectFactory {
    private final PriorityPropertyFactory propertyFactory;

    public ConfigObjectFactory(PriorityPropertyFactory propertyFactory) {
        this.propertyFactory = propertyFactory;
    }

    public PriorityPropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    public <T> ConfigObject<T> create(Class<T> cls, Map<String, Object> parameters) {
        try {
            return this.create(cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), parameters);
        }
        catch (Throwable e) {
            throw new IllegalStateException("create config object failed, class=" + cls.getName(), e);
        }
    }

    public <T> ConfigObject<T> create(T instance, Map<String, Object> parameters) {
        String prefix = this.initPrefix(instance.getClass());
        List<ConfigObjectProperty> properties = this.createProperties(instance, prefix, parameters);
        return new ConfigObject<T>(instance, properties);
    }

    private String initPrefix(Class<?> cls) {
        InjectProperties injectProperties = cls.getAnnotation(InjectProperties.class);
        if (injectProperties == null) {
            return "";
        }
        String prefix = injectProperties.prefix();
        if (prefix.isEmpty()) {
            return "";
        }
        return prefix + ".";
    }

    public List<ConfigObjectProperty> createProperties(Object instance, String prefix, Map<String, Object> parameters) {
        ArrayList<ConfigObjectProperty> properties = new ArrayList<ConfigObjectProperty>();
        JavaType javaType = TypeFactory.defaultInstance().constructType(instance.getClass());
        BeanDescription beanDescription = JsonUtils.OBJ_MAPPER.getSerializationConfig().introspect(javaType);
        for (BeanPropertyDefinition propertyDefinition : beanDescription.findProperties()) {
            if (propertyDefinition.getField() == null || propertyDefinition.getSetter() == null && !propertyDefinition.getField().isPublic()) continue;
            Setter setter = LambdaMetafactoryUtils.createObjectSetter((BeanPropertyDefinition)propertyDefinition);
            PriorityProperty<?> priorityProperty = this.createPriorityProperty(propertyDefinition.getField().getAnnotated(), prefix, parameters);
            setter.set(instance, priorityProperty.getValue());
            properties.add(new ConfigObjectProperty((Setter<Object, Object>)setter, priorityProperty));
        }
        return properties;
    }

    private PriorityProperty<?> createPriorityProperty(Field field, String prefix, Map<String, Object> parameters) {
        String[] keys = this.collectPropertyKeys(field, prefix, parameters);
        Class<?> fieldCls = field.getType();
        switch (fieldCls.getName()) {
            case "int": {
                return this.createIntProperty(field, keys, 0);
            }
            case "java.lang.Integer": {
                return this.createIntProperty(field, keys, null);
            }
            case "long": {
                return this.createLongProperty(field, keys, 0L);
            }
            case "java.lang.Long": {
                return this.createLongProperty(field, keys, null);
            }
            case "java.lang.String": {
                return this.createStringProperty(field, keys);
            }
            case "float": {
                return this.createFloatProperty(field, keys, Float.valueOf(0.0f));
            }
            case "java.lang.Float": {
                return this.createFloatProperty(field, keys, null);
            }
            case "double": {
                return this.createDoubleProperty(field, keys, 0.0);
            }
            case "java.lang.Double": {
                return this.createDoubleProperty(field, keys, null);
            }
            case "boolean": {
                return this.createBooleanProperty(field, keys, false);
            }
            case "java.lang.Boolean": {
                return this.createBooleanProperty(field, keys, null);
            }
        }
        throw new IllegalStateException("not support, field=" + field);
    }

    private PriorityProperty<?> createStringProperty(Field field, String[] keys) {
        String defaultValue = null;
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = injectProperty.defaultValue();
        }
        return this.propertyFactory.getOrCreate((Type)((Object)String.class), null, defaultValue, keys);
    }

    private PriorityProperty<?> createDoubleProperty(Field field, String[] keys, Double defaultValue) {
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = Double.parseDouble(injectProperty.defaultValue());
        }
        return this.propertyFactory.getOrCreate((Type)((Object)Double.class), null, defaultValue, keys);
    }

    private PriorityProperty<?> createFloatProperty(Field field, String[] keys, Float defaultValue) {
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = Float.valueOf(Float.parseFloat(injectProperty.defaultValue()));
        }
        return this.propertyFactory.getOrCreate((Type)((Object)Float.class), null, defaultValue, keys);
    }

    private PriorityProperty<?> createBooleanProperty(Field field, String[] keys, Boolean defaultValue) {
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = Boolean.parseBoolean(injectProperty.defaultValue());
        }
        return this.propertyFactory.getOrCreate((Type)((Object)Boolean.class), null, defaultValue, keys);
    }

    private PriorityProperty<?> createLongProperty(Field field, String[] keys, Long defaultValue) {
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = Long.parseLong(injectProperty.defaultValue());
        }
        return this.propertyFactory.getOrCreate((Type)((Object)Long.class), null, defaultValue, keys);
    }

    private PriorityProperty<?> createIntProperty(Field field, String[] keys, Integer defaultValue) {
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null && !injectProperty.defaultValue().isEmpty()) {
            defaultValue = Integer.parseInt(injectProperty.defaultValue());
        }
        return this.propertyFactory.getOrCreate((Type)((Object)Integer.class), null, defaultValue, keys);
    }

    private String[] collectPropertyKeys(Field field, String prefix, Map<String, Object> parameters) {
        String propertyPrefix = prefix;
        String[] keys = new String[]{field.getName()};
        InjectProperty injectProperty = field.getAnnotation(InjectProperty.class);
        if (injectProperty != null) {
            if (!injectProperty.prefix().isEmpty()) {
                propertyPrefix = injectProperty.prefix() + ".";
            }
            if (injectProperty.keys().length != 0) {
                keys = injectProperty.keys();
            }
        }
        ArrayList<String> finalKeys = new ArrayList<String>();
        for (String key : keys) {
            List<String> resolvedKeys = new PlaceholderResolver().replace(propertyPrefix + key, parameters);
            finalKeys.addAll(resolvedKeys);
        }
        return finalKeys.toArray(new String[0]);
    }
}

