/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;

public class ZoneAwareDiscoveryFilter
extends AbstractDiscoveryFilter {
    public static final String KEY_ZONE_AWARE_STEP = "_KEY_ZONE_AWARE_STEP";
    private static final String GROUP_RegionAndAZMatch = "instancesRegionAndAZMatch";
    private static final String GROUP_InstancesAZMatch = "instancesAZMatch";
    private static final String GROUP_InstancesNoMatch = "instancesNoMatch";
    public static final String GROUP_Instances_All = "instancesAll";

    public int getOrder() {
        return 300;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.zoneaware.enabled", true).get();
    }

    public boolean isGroupingFilter() {
        return true;
    }

    protected void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        MicroserviceInstance myself = RegistrationManager.INSTANCE.getMicroserviceInstance();
        HashMap instancesRegionAndAZMatch = new HashMap();
        HashMap instancesAZMatch = new HashMap();
        HashMap instancesNoMatch = new HashMap();
        Map instances = (Map)parent.data();
        instances.forEach((id, target) -> {
            if (this.regionAndAZMatch(myself, (MicroserviceInstance)target)) {
                instancesRegionAndAZMatch.put(id, target);
            } else if (this.regionMatch(myself, (MicroserviceInstance)target)) {
                instancesAZMatch.put(id, target);
            } else {
                instancesNoMatch.put(id, target);
            }
        });
        HashMap<String, VersionedCache> children = new HashMap<String, VersionedCache>();
        children.put(GROUP_RegionAndAZMatch, new DiscoveryTreeNode().subName((VersionedCache)parent, GROUP_RegionAndAZMatch).data(instancesRegionAndAZMatch));
        children.put(GROUP_InstancesAZMatch, new DiscoveryTreeNode().subName((VersionedCache)parent, GROUP_InstancesAZMatch).data(instancesAZMatch));
        children.put(GROUP_InstancesNoMatch, new DiscoveryTreeNode().subName((VersionedCache)parent, GROUP_InstancesNoMatch).data(instancesNoMatch));
        children.put(GROUP_Instances_All, new DiscoveryTreeNode().subName((VersionedCache)parent, GROUP_Instances_All).data((Object)instances));
        parent.children(children);
    }

    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        String key = (String)context.getContextParameter(KEY_ZONE_AWARE_STEP);
        if (key == null) {
            key = GROUP_RegionAndAZMatch;
            context.pushRerunFilter();
        } else if (GROUP_RegionAndAZMatch.equals(key)) {
            key = GROUP_InstancesAZMatch;
            context.pushRerunFilter();
        } else if (GROUP_InstancesAZMatch.equals(key)) {
            key = GROUP_InstancesNoMatch;
            context.pushRerunFilter();
        } else if (GROUP_InstancesNoMatch.equals(key)) {
            key = GROUP_Instances_All;
        } else {
            throw new ServiceCombException("not possible happen, maybe a bug.");
        }
        context.putContextParameter(KEY_ZONE_AWARE_STEP, (Object)key);
        return key;
    }

    private boolean regionAndAZMatch(MicroserviceInstance myself, MicroserviceInstance target) {
        if (myself.getDataCenterInfo() == null) {
            return true;
        }
        if (target.getDataCenterInfo() != null) {
            return myself.getDataCenterInfo().getRegion().equals(target.getDataCenterInfo().getRegion()) && myself.getDataCenterInfo().getAvailableZone().equals(target.getDataCenterInfo().getAvailableZone());
        }
        return false;
    }

    private boolean regionMatch(MicroserviceInstance myself, MicroserviceInstance target) {
        if (target.getDataCenterInfo() != null) {
            return myself.getDataCenterInfo().getRegion().equals(target.getDataCenterInfo().getRegion());
        }
        return false;
    }
}

