/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.center.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.center.client.AddressManager;
import org.apache.servicecomb.config.center.client.ConfigCenterOperation;
import org.apache.servicecomb.config.center.client.exception.OperationException;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsRequest;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsResponse;
import org.apache.servicecomb.http.client.common.HttpRequest;
import org.apache.servicecomb.http.client.common.HttpResponse;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCenterClient
implements ConfigCenterOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCenterClient.class);
    public static final String DEFAULT_APP_SEPARATOR = "@";
    public static final String DEFAULT_SERVICE_SEPARATOR = "#";
    public static final String REVISION = "revision";
    public static final String APPLICATION_CONFIG = "application";
    public static final String DARK_LAUNCH = "darklaunch@";
    private final HttpTransport httpTransport;
    private final AddressManager addressManager;

    public ConfigCenterClient(AddressManager addressManager, HttpTransport httpTransport) {
        this.addressManager = addressManager;
        this.httpTransport = httpTransport;
    }

    @Override
    public QueryConfigurationsResponse queryConfigurations(QueryConfigurationsRequest request) {
        String dimensionsInfo = this.buildDimensionsInfo(request, true);
        QueryConfigurationsResponse queryConfigurationsResponse = new QueryConfigurationsResponse();
        HashMap<String, Object> configurations = new HashMap<String, Object>();
        String uri = null;
        String address = this.addressManager.address();
        try {
            uri = address + "/configuration/items?dimensionsInfo=" + HttpUtils.encodeURLParam((String)dimensionsInfo) + "&revision=" + request.getRevision();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-environment", request.getEnvironment());
            HttpRequest httpRequest = new HttpRequest(uri, headers, null, "GET");
            HttpResponse httpResponse = this.httpTransport.doRequest(httpRequest);
            if (httpResponse.getStatusCode() == 200) {
                Map allConfigMap = (Map)HttpUtils.deserialize((String)httpResponse.getContent(), (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
                if (allConfigMap.get(REVISION) != null) {
                    queryConfigurationsResponse.setRevision((String)((Map)allConfigMap.get(REVISION)).get("version"));
                }
                if (allConfigMap.get(APPLICATION_CONFIG) != null) {
                    configurations.putAll((Map)allConfigMap.get(APPLICATION_CONFIG));
                }
                if (allConfigMap.get(this.buildDimensionsInfo(request, false)) != null) {
                    configurations.putAll((Map)allConfigMap.get(this.buildDimensionsInfo(request, false)));
                }
                if (allConfigMap.get(this.buildDarkLaunchDimensionsInfo(request)) != null) {
                    configurations.putAll((Map)allConfigMap.get(this.buildDarkLaunchDimensionsInfo(request)));
                }
                if (allConfigMap.get(dimensionsInfo) != null) {
                    configurations.putAll((Map)allConfigMap.get(dimensionsInfo));
                }
                queryConfigurationsResponse.setConfigurations(configurations);
                queryConfigurationsResponse.setChanged(true);
                this.addressManager.recordSuccessState(address);
                return queryConfigurationsResponse;
            }
            if (httpResponse.getStatusCode() == 304) {
                queryConfigurationsResponse.setChanged(false);
                this.addressManager.recordSuccessState(address);
                return queryConfigurationsResponse;
            }
            if (httpResponse.getStatusCode() == 400) {
                throw new OperationException("Bad request for query configurations.");
            }
            this.addressManager.recordFailState(address);
            throw new OperationException("read response failed. status:" + httpResponse.getStatusCode() + "; message:" + httpResponse.getMessage() + "; content:" + httpResponse.getContent());
        }
        catch (IOException e) {
            this.addressManager.recordFailState(address);
            LOGGER.error("query configuration from {} failed, message={}", uri, (Object)e.getMessage());
            throw new OperationException("", e);
        }
    }

    private String buildDimensionsInfo(QueryConfigurationsRequest request, boolean withVersion) {
        String result = request.getServiceName() + DEFAULT_APP_SEPARATOR + request.getApplication();
        if (withVersion && !StringUtils.isEmpty((CharSequence)request.getVersion())) {
            result = result + DEFAULT_SERVICE_SEPARATOR + request.getVersion();
        }
        return result;
    }

    private String buildDarkLaunchDimensionsInfo(QueryConfigurationsRequest request) {
        return DARK_LAUNCH + request.getApplication();
    }
}

