/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor.data;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;

public class CPUMonitorCalc {
    private static final int PERCENTAGE = 100;
    private static final CPUMonitorCalc instance = new CPUMonitorCalc();
    private final OperatingSystemMXBean osMxBean;
    private final ThreadMXBean threadMXBean;
    private long preTime = System.nanoTime();
    private long preUsedTime = 0L;

    public CPUMonitorCalc() {
        this.osMxBean = ManagementFactory.getOperatingSystemMXBean();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
    }

    public static CPUMonitorCalc getInstance() {
        return instance;
    }

    public double getProcessCpu() {
        long totalTime = 0L;
        for (long id : this.threadMXBean.getAllThreadIds()) {
            totalTime += this.threadMXBean.getThreadCpuTime(id);
        }
        long curtime = System.nanoTime();
        long usedTime = totalTime - this.preUsedTime;
        long totalPassedTime = curtime - this.preTime;
        this.preTime = curtime;
        this.preUsedTime = totalTime;
        return (double)usedTime / (double)totalPassedTime / (double)this.osMxBean.getAvailableProcessors() * 100.0;
    }
}

