/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import com.google.common.eventbus.Subscribe;
import com.netflix.hystrix.HystrixCommandMetrics;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.CPUMonitorCalc;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.Diagnosis;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.MonitorConstant;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.MonitorData;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.model.MonitorDaraProvider;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.diagnosis.instance.InstanceCacheChecker;
import org.apache.servicecomb.serviceregistry.diagnosis.instance.InstanceCacheSummary;

public class HealthMonitorDataProvider
implements MonitorDaraProvider {
    private InstanceCacheSummary instanceCacheSummary;
    private final Object lock = new Object();

    @Override
    public String getURL() {
        return String.format(MonitorConstant.MONITORS_URI, RegistryUtils.getMicroservice().getServiceName());
    }

    @Override
    public Object getData() {
        return this.getMonitorData();
    }

    @PostConstruct
    public void init() {
        EventManager.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void subCacheCheck(InstanceCacheSummary instanceCacheSummary) {
        Object object = this.lock;
        synchronized (object) {
            this.instanceCacheSummary = instanceCacheSummary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MonitorData getMonitorData() {
        Collection instances = HystrixCommandMetrics.getInstances();
        MonitorData monitorData = new MonitorData();
        Microservice microservice = RegistryUtils.getMicroservice();
        MicroserviceInstance microserviceInstance = RegistryUtils.getMicroserviceInstance();
        monitorData.setAppId(microservice.getAppId());
        monitorData.setName(microservice.getServiceName());
        monitorData.setVersion(microservice.getVersion());
        monitorData.setServiceId(microservice.getServiceId());
        monitorData.setInstance(microserviceInstance.getHostName());
        monitorData.setInstanceId(microserviceInstance.getInstanceId());
        if (MonitorConstant.insCacheEnabled()) {
            InstanceCacheChecker checker = new InstanceCacheChecker(DiscoveryManager.INSTANCE.getAppManager());
            monitorData.setProvidersCache(checker.check().getProducers());
        }
        this.exactProcessInfo(monitorData);
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (this.instanceCacheSummary != null) {
                Diagnosis diagnosis = new Diagnosis();
                diagnosis.setInstanceCache(this.instanceCacheSummary);
                monitorData.setDiagnosis(diagnosis);
                this.instanceCacheSummary = null;
            }
        }
        if (instances.isEmpty()) {
            return monitorData;
        }
        for (HystrixCommandMetrics instance : instances) {
            monitorData.appendInterfaceInfo(instance);
        }
        return monitorData;
    }

    private void exactProcessInfo(MonitorData monitorData) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryHeapUsage = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage memoryNonHeapUsage = memoryMXBean.getNonHeapMemoryUsage();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        int threadCount = threadMXBean.getThreadCount();
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        double cpu = operatingSystemMXBean.getSystemLoadAverage();
        monitorData.setCpu(CPUMonitorCalc.getInstance().getProcessCpu());
        monitorData.setLoadAverage(cpu);
        monitorData.setThreadCount(threadCount);
        monitorData.setUptime(runtimeMXBean.getUptime());
        HashMap<String, Long> memoryInfo = new HashMap<String, Long>();
        memoryInfo.put("heapInit", memoryHeapUsage.getInit());
        memoryInfo.put("headMax", memoryHeapUsage.getMax());
        memoryInfo.put("heapCommit", memoryHeapUsage.getCommitted());
        memoryInfo.put("heapUsed", memoryHeapUsage.getUsed());
        memoryInfo.put("nonHeapInit", memoryNonHeapUsage.getInit());
        memoryInfo.put("nonHeapCommit", memoryNonHeapUsage.getCommitted());
        memoryInfo.put("nonHeapUsed", memoryNonHeapUsage.getUsed());
        monitorData.setMemory(memoryInfo);
    }
}

