/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.parser.impl;

import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.common.accessLog.core.element.impl.PlainTextAccessItem;
import org.apache.servicecomb.common.accessLog.core.parser.AccessLogPatternParser;
import org.apache.servicecomb.common.accessLog.core.parser.CompositeVertxRestAccessLogItemMeta;
import org.apache.servicecomb.common.accessLog.core.parser.VertxRestAccessLogItemMeta;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxRestAccessLogPatternParser
implements AccessLogPatternParser<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxRestAccessLogPatternParser.class);
    public static final Comparator<VertxRestAccessLogItemMeta> accessLogItemMetaComparator = (m1, m2) -> {
        int result = m1.getOrder() - m2.getOrder();
        if (result != 0) {
            return result;
        }
        if (m1.getSuffix() == null ^ m2.getSuffix() == null) {
            return m1.getSuffix() == null ? 1 : -1;
        }
        if (null != m1.getSuffix()) {
            result = VertxRestAccessLogPatternParser.comparePlaceholderString(m1.getSuffix(), m2.getSuffix());
        }
        return 0 == result ? VertxRestAccessLogPatternParser.comparePlaceholderString(m1.getPrefix(), m2.getPrefix()) : result;
    };
    private final List<VertxRestAccessLogItemMeta> metaList = new ArrayList<VertxRestAccessLogItemMeta>();

    public VertxRestAccessLogPatternParser() {
        List<VertxRestAccessLogItemMeta> loadedMeta = this.loadVertxRestLogItemMeta();
        if (null == loadedMeta || loadedMeta.isEmpty()) {
            LOGGER.error("cannot load AccessLogItemMeta!");
            throw new IllegalStateException("cannot load AccessLogItemMeta!");
        }
        for (VertxRestAccessLogItemMeta meta : loadedMeta) {
            if (CompositeVertxRestAccessLogItemMeta.class.isAssignableFrom(meta.getClass())) {
                this.metaList.addAll(((CompositeVertxRestAccessLogItemMeta)meta).getAccessLogItemMetas());
                continue;
            }
            this.metaList.add(meta);
        }
        VertxRestAccessLogPatternParser.sortAccessLogItemMeta(this.metaList);
    }

    private List<VertxRestAccessLogItemMeta> loadVertxRestLogItemMeta() {
        return SPIServiceUtils.getOrLoadSortedService(VertxRestAccessLogItemMeta.class);
    }

    public static int comparePlaceholderString(String s1, String s2) {
        int result = s1.compareTo(s2);
        if (0 == result) {
            return result;
        }
        return result < 0 ? (s2.startsWith(s1) ? -result : result) : (s1.startsWith(s2) ? -result : result);
    }

    public static void sortAccessLogItemMeta(List<VertxRestAccessLogItemMeta> accessLogItemMetaList) {
        accessLogItemMetaList.sort(accessLogItemMetaComparator);
    }

    @Override
    public List<AccessLogItem<RoutingContext>> parsePattern(String rawPattern) {
        LOGGER.info("parse the pattern of access log: [{}]", (Object)rawPattern);
        List<AccessLogItemLocation> locationList = this.matchAccessLogItem(rawPattern);
        locationList = this.fillInPlainTextLocation(rawPattern, locationList);
        return this.convertToItemList(rawPattern, locationList);
    }

    private List<AccessLogItemLocation> matchAccessLogItem(String rawPattern) {
        ArrayList<AccessLogItemLocation> locationList = new ArrayList<AccessLogItemLocation>();
        int cursor = 0;
        while (cursor < rawPattern.length()) {
            AccessLogItemLocation candidate = null;
            for (VertxRestAccessLogItemMeta meta : this.metaList) {
                if (null != candidate && null == meta.getSuffix()) {
                    cursor = candidate.tail;
                    break;
                }
                if (!rawPattern.startsWith(meta.getPrefix(), cursor)) continue;
                if (null == meta.getSuffix()) {
                    candidate = new AccessLogItemLocation(cursor, meta);
                    cursor = candidate.tail;
                    break;
                }
                int rear = rawPattern.indexOf(meta.getSuffix(), cursor);
                if (rear < 0 || null != candidate && rear >= candidate.suffixIndex) continue;
                candidate = new AccessLogItemLocation(cursor, rear, meta);
            }
            if (candidate == null) {
                ++cursor;
                continue;
            }
            locationList.add(candidate);
        }
        return locationList;
    }

    private List<AccessLogItemLocation> fillInPlainTextLocation(String rawPattern, List<AccessLogItemLocation> locationList) {
        ArrayList<AccessLogItemLocation> resultList = new ArrayList<AccessLogItemLocation>();
        if (locationList.isEmpty()) {
            resultList.add(this.createTextPlainItemLocation(0, rawPattern.length()));
            return resultList;
        }
        Iterator<AccessLogItemLocation> itemLocationIterator = locationList.iterator();
        AccessLogItemLocation previousItemLocation = itemLocationIterator.next();
        if (previousItemLocation.prefixIndex > 0) {
            resultList.add(this.createTextPlainItemLocation(0, previousItemLocation.prefixIndex));
        }
        resultList.add(previousItemLocation);
        while (itemLocationIterator.hasNext()) {
            AccessLogItemLocation thisItemLocation = itemLocationIterator.next();
            if (previousItemLocation.tail < thisItemLocation.prefixIndex) {
                resultList.add(this.createTextPlainItemLocation(previousItemLocation.tail, thisItemLocation.prefixIndex));
            }
            previousItemLocation = thisItemLocation;
            resultList.add(previousItemLocation);
        }
        if (previousItemLocation.tail < rawPattern.length()) {
            resultList.add(this.createTextPlainItemLocation(previousItemLocation.tail, rawPattern.length()));
        }
        return resultList;
    }

    private AccessLogItemLocation createTextPlainItemLocation(int front, int rear) {
        return new AccessLogItemLocation(front, rear);
    }

    private List<AccessLogItem<RoutingContext>> convertToItemList(String rawPattern, List<AccessLogItemLocation> locationList) {
        ArrayList<AccessLogItem<RoutingContext>> itemList = new ArrayList<AccessLogItem<RoutingContext>>();
        for (AccessLogItemLocation accessLogItemLocation : locationList) {
            VertxRestAccessLogItemMeta accessLogItemMeta = accessLogItemLocation.accessLogItemMeta;
            if (null == accessLogItemMeta) {
                itemList.add(new PlainTextAccessItem(rawPattern.substring(accessLogItemLocation.prefixIndex, accessLogItemLocation.tail)));
                continue;
            }
            itemList.add(accessLogItemMeta.getAccessLogItemCreator().createItem(this.getConfigString(rawPattern, accessLogItemLocation)));
        }
        return itemList;
    }

    private String getConfigString(String rawPattern, AccessLogItemLocation accessLogItemLocation) {
        if (null == accessLogItemLocation.getSuffix()) {
            return null;
        }
        return rawPattern.substring(accessLogItemLocation.prefixIndex + accessLogItemLocation.getPrefix().length(), accessLogItemLocation.suffixIndex);
    }

    private static class AccessLogItemLocation {
        int prefixIndex;
        int suffixIndex;
        int tail;
        VertxRestAccessLogItemMeta accessLogItemMeta;

        AccessLogItemLocation(int prefixIndex, int suffixIndex) {
            this.prefixIndex = prefixIndex;
            this.suffixIndex = suffixIndex;
            this.tail = suffixIndex;
        }

        AccessLogItemLocation(int prefixIndex, int suffixIndex, VertxRestAccessLogItemMeta accessLogItemMeta) {
            this.prefixIndex = prefixIndex;
            this.suffixIndex = suffixIndex;
            this.tail = suffixIndex + accessLogItemMeta.getSuffix().length();
            this.accessLogItemMeta = accessLogItemMeta;
        }

        AccessLogItemLocation(int prefixIndex, VertxRestAccessLogItemMeta accessLogItemMeta) {
            this.prefixIndex = prefixIndex;
            this.tail = this.suffixIndex = prefixIndex + accessLogItemMeta.getPrefix().length();
            this.accessLogItemMeta = accessLogItemMeta;
        }

        public String getPrefix() {
            if (null == this.accessLogItemMeta) {
                return null;
            }
            return this.accessLogItemMeta.getPrefix();
        }

        public String getSuffix() {
            if (null == this.accessLogItemMeta) {
                return null;
            }
            return this.accessLogItemMeta.getSuffix();
        }
    }
}

