/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.servicecomb.foundation.common.utils.AbstractRestObjectMapper;
import org.apache.servicecomb.foundation.common.utils.RestObjectMapper;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;

public class RestObjectMapperFactory {
    private static AbstractRestObjectMapper defaultMapper = new RestObjectMapper();
    private static final AbstractRestObjectMapper viewMapper = new RestObjectMapper();
    private static AbstractRestObjectMapper consumerWriterMapper = defaultMapper;

    private static void registerModules(ObjectMapper mapper) {
        List modules = SPIServiceUtils.getOrLoadSortedService(Module.class);
        mapper.registerModules(modules.toArray(new Module[modules.size()]));
    }

    public static AbstractRestObjectMapper getConsumerWriterMapper() {
        return consumerWriterMapper;
    }

    public static AbstractRestObjectMapper getRestObjectMapper() {
        return defaultMapper;
    }

    public static AbstractRestObjectMapper getRestViewMapper() {
        return viewMapper;
    }

    public static void setConsumerWriterMapper(AbstractRestObjectMapper customMapper) {
        RestObjectMapperFactory.registerModules((ObjectMapper)customMapper);
        consumerWriterMapper = customMapper;
    }

    public static void setDefaultRestObjectMapper(AbstractRestObjectMapper customMapper) {
        RestObjectMapperFactory.registerModules((ObjectMapper)customMapper);
        defaultMapper = customMapper;
    }

    static {
        RestObjectMapperFactory.registerModules((ObjectMapper)defaultMapper);
        RestObjectMapperFactory.registerModules((ObjectMapper)viewMapper);
    }
}

