/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.servicestage;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.auth.Cipher;
import org.apache.servicecomb.foundation.auth.DefaultCipher;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AKSKAuthHeaderProvider
implements AuthHeaderProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AKSKAuthHeaderProvider.class);
    private static final String CONFIG_AKSK_ENABLED = "servicecomb.credentials.akskEnabled";
    private static final String CONFIG_ACCESS_KEY = "servicecomb.credentials.accessKey";
    private static final String CONFIG_SECRET_KEY = "servicecomb.credentials.secretKey";
    private static final String CONFIG_CIPHER = "servicecomb.credentials.akskCustomCipher";
    private static final String CONFIG_PROJECT = "servicecomb.credentials.project";
    private static final String VALUE_DEFAULT_PROJECT = "default";
    private static final String VALUE_DEFAULT_CIPHER = "default";
    private static final String X_SERVICE_AK = "X-Service-AK";
    private static final String X_SERVICE_SHAAKSK = "X-Service-ShaAKSK";
    private static final String X_SERVICE_PROJECT = "X-Service-Project";
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Configuration configuration;
    private boolean enabled;
    private final boolean loaded = false;

    public AKSKAuthHeaderProvider() {
        this((Configuration)ConfigUtil.createLocalConfig());
    }

    public AKSKAuthHeaderProvider(Configuration configuration) {
        this.configuration = configuration;
        this.enabled = configuration.getBoolean(CONFIG_AKSK_ENABLED, true);
    }

    public Map<String, String> authHeaders() {
        if (!this.enabled) {
            return this.headers;
        }
        if (StringUtils.isEmpty((CharSequence)this.getAccessKey())) {
            LOGGER.warn("ak sk auth enabled but access key is not configured, disable it at runtime. Config [{}] to false to disable it implicitly.", (Object)CONFIG_AKSK_ENABLED);
            this.enabled = false;
            return this.headers;
        }
        this.load();
        return this.headers;
    }

    private synchronized void load() {
        this.headers.put(X_SERVICE_AK, this.getAccessKey());
        this.headers.put(X_SERVICE_SHAAKSK, this.getSecretKey());
        this.headers.put(X_SERVICE_PROJECT, this.getProject());
    }

    private String getAccessKey() {
        return this.configuration.getString(CONFIG_ACCESS_KEY, "");
    }

    private String getCipher() {
        return this.configuration.getString(CONFIG_CIPHER, "default");
    }

    private String getSecretKey() {
        String secretKey = this.configuration.getString(CONFIG_SECRET_KEY, "");
        String decodedSecretKey = new String(this.findCipher().decrypt(secretKey.toCharArray()));
        if ("ShaAKSKCipher".equalsIgnoreCase(this.getCipher())) {
            return decodedSecretKey;
        }
        return AKSKAuthHeaderProvider.sha256Encode(decodedSecretKey, this.getAccessKey());
    }

    private String getProject() {
        String project = this.configuration.getString(CONFIG_PROJECT, "default");
        if (StringUtils.isEmpty((CharSequence)project)) {
            return project;
        }
        try {
            return URLEncoder.encode(project, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return project;
        }
    }

    private Cipher findCipher() {
        if ("default".equals(this.getCipher())) {
            return DefaultCipher.getInstance();
        }
        List ciphers = SPIServiceUtils.getOrLoadSortedService(Cipher.class);
        return ciphers.stream().filter(c -> c.name().equals(this.getCipher())).findFirst().orElseThrow(() -> new IllegalArgumentException("failed to find cipher named " + this.getCipher()));
    }

    public static String sha256Encode(String key, String data) {
        try {
            Mac sha256HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            sha256HMAC.init(secretKey);
            return Hex.encodeHexString((byte[])sha256HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not encode ak sk. Please check the value is correct.", e);
        }
    }
}

