/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.loadbalance.filter.InstancePropertyDiscoveryFilter;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityInstancePropertyDiscoveryFilter
extends AbstractDiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PriorityInstancePropertyDiscoveryFilter.class);
    private static final String ALL_INSTANCE = "allInstance";
    private String propertyKey;

    protected void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        this.propertyKey = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.loadbalance.filter.priorityInstanceProperty.key", "environment").get();
        Map instances = (Map)parent.data();
        HashMap<String, Map> groupByProperty = new HashMap<String, Map>();
        for (MicroserviceInstance microserviceInstance : instances.values()) {
            String propertyValue = new PriorityInstanceProperty(this.propertyKey, microserviceInstance).getPropertyValue();
            groupByProperty.computeIfAbsent(propertyValue, key -> new HashMap()).put(microserviceInstance.getInstanceId(), microserviceInstance);
        }
        HashMap children = new HashMap();
        for (Map.Entry entry : groupByProperty.entrySet()) {
            children.put(entry.getKey(), new DiscoveryTreeNode().subName((VersionedCache)parent, (String)entry.getKey()).data(entry.getValue()));
        }
        children.put(ALL_INSTANCE, new DiscoveryTreeNode().subName((VersionedCache)parent, ALL_INSTANCE).data((Object)instances));
        parent.children(children);
    }

    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        Invocation invocation = (Invocation)context.getInputParameters();
        String initPropertyValue = invocation.getContext().computeIfAbsent("x-" + this.propertyKey, key -> new PriorityInstanceProperty(this.propertyKey, RegistrationManager.INSTANCE.getMicroserviceInstance()).getPropertyValue());
        PriorityInstanceProperty currentProperty = (PriorityInstanceProperty)context.getContextParameter(this.propertyKey);
        if (Objects.isNull(currentProperty)) {
            currentProperty = new PriorityInstanceProperty(this.propertyKey, initPropertyValue);
            while (!parent.children().containsKey(currentProperty.getPropertyValue()) && currentProperty.hasChildren()) {
                currentProperty = currentProperty.child();
            }
        } else if (currentProperty.hasChildren()) {
            currentProperty = currentProperty.child();
        }
        LOGGER.debug("Discovery instance filter by {}", (Object)currentProperty.toString());
        context.putContextParameter(this.propertyKey, (Object)currentProperty);
        if (currentProperty.isEmpty()) {
            return currentProperty.getPropertyValue();
        }
        context.pushRerunFilter();
        return currentProperty.getPropertyValue();
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.priorityInstanceProperty.enabled", false).get();
    }

    public int getOrder() {
        return new InstancePropertyDiscoveryFilter().getOrder() + 1;
    }

    static class PriorityInstanceProperty {
        private static final int MAX_LENGTH = 10000;
        private static final String SEPARATOR = ".";
        private final String propertyKey;
        private final String propertyVal;

        public PriorityInstanceProperty(@NotNull String key, String value) {
            this.propertyKey = key;
            if (Objects.isNull(value)) {
                value = "";
            }
            if (value.length() > 10000) {
                throw new IllegalArgumentException("property value exceed max length");
            }
            this.propertyVal = value;
        }

        public PriorityInstanceProperty(@NotNull String key, @NotNull MicroserviceInstance microserviceInstance) {
            this(key, Optional.ofNullable(microserviceInstance.getProperties().get(key)).orElse(""));
        }

        public boolean isEmpty() {
            return StringUtils.isEmpty((CharSequence)this.propertyVal);
        }

        public boolean hasChildren() {
            return StringUtils.isNotEmpty((CharSequence)this.propertyVal);
        }

        public PriorityInstanceProperty child() {
            if (this.propertyVal.contains(SEPARATOR)) {
                return new PriorityInstanceProperty(this.propertyKey, StringUtils.substringBeforeLast((String)this.propertyVal, (String)SEPARATOR));
            }
            return new PriorityInstanceProperty(this.propertyKey, "");
        }

        public String getPropertyValue() {
            return this.propertyVal;
        }

        public String toString() {
            return "PriorityInstanceProperty{key=" + this.propertyKey + ", value=" + this.propertyVal + '}';
        }
    }
}

