/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.servicecomb.foundation.metrics.publish.spectator;

import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestTagFinder {

  @Test
  public void buildFromString() {
    String name = "key";
    TagFinder finder = TagFinder.build(name);

    Assert.assertEquals(name, finder.getTagKey());
    Assert.assertEquals(DefaultTagFinder.class, finder.getClass());
  }

  @Test
  public void buildFromTagFinder() {
    TagFinder finder = new DefaultTagFinder("key");
    Assert.assertSame(finder, TagFinder.build(finder));
    DefaultTagFinder tagFinder = new DefaultTagFinder("key", true);
    Assert.assertSame(tagFinder, TagFinder.build(tagFinder));
  }

  @Test
  public void buildFromInvalidType() {
    IllegalArgumentException exception = Assertions.assertThrows(IllegalArgumentException.class, () -> TagFinder.build(1));
    Assertions.assertEquals("only support String or TagFinder, but got " + Integer.class.getName(), exception.getMessage());
  }

  @Test
  public void buildFromNull() {
    IllegalArgumentException exception = Assertions.assertThrows(IllegalArgumentException.class, () -> TagFinder.build(null));
    Assertions.assertEquals("only support String or TagFinder, but got null", exception.getMessage());
  }
}
